/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.rabbitmq;

import java.util.Properties;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.wso2.carbon.inbound.endpoint.common.InboundOneTimeTriggerRequestProcessor;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQConnectionFactory;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQConsumer;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQException;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.rabbitmq.RabbitMQTask;

public class RabbitMQListener
extends InboundOneTimeTriggerRequestProcessor {
    private static final String ENDPOINT_POSTFIX = "RABBITMQ--SYNAPSE_INBOUND_ENDPOINT";
    private static final Log log = LogFactory.getLog(RabbitMQListener.class);
    private String injectingSeq;
    private String onErrorSeq;
    private Properties rabbitmqProperties;
    private boolean sequential;
    private RabbitMQConnectionFactory rabbitMQConnectionFactory;
    private RabbitMQConsumer rabbitMQConsumer;
    private RabbitMQInjectHandler injectHandler;

    public RabbitMQListener(InboundProcessorParams params) {
        this.name = params.getName();
        this.injectingSeq = params.getInjectingSeq();
        this.onErrorSeq = params.getOnErrorSeq();
        this.synapseEnvironment = params.getSynapseEnvironment();
        this.rabbitmqProperties = params.getProperties();
        this.sequential = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)this.rabbitmqProperties.getProperty("sequential")), (boolean)true);
        this.coordination = BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)this.rabbitmqProperties.getProperty("coordination")), (boolean)true);
        try {
            this.rabbitMQConnectionFactory = new RabbitMQConnectionFactory(this.rabbitmqProperties);
        }
        catch (RabbitMQException e) {
            throw new SynapseException("Error occurred while initializing the connection factory.", (Throwable)e);
        }
        this.injectHandler = new RabbitMQInjectHandler(this.injectingSeq, this.onErrorSeq, this.sequential, this.synapseEnvironment);
    }

    @Override
    public void destroy() {
        this.rabbitMQConsumer.close();
        super.destroy();
    }

    public void init() {
        log.info((Object)("RABBITMQ inbound endpoint " + this.name + " initializing ..."));
        this.rabbitMQConsumer = new RabbitMQConsumer(this.rabbitMQConnectionFactory, this.rabbitmqProperties, this.injectHandler);
        this.rabbitMQConsumer.setInboundName(this.name);
        this.start();
    }

    private void start() {
        RabbitMQTask rabbitMQTask = new RabbitMQTask(this.rabbitMQConsumer);
        this.start(rabbitMQTask, ENDPOINT_POSTFIX);
    }
}

