/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.websocket;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.inbound.InboundEndpoint;
import org.apache.synapse.inbound.InboundProcessorParams;
import org.apache.synapse.inbound.InboundRequestProcessor;
import org.wso2.carbon.inbound.endpoint.persistence.PersistenceUtils;
import org.wso2.carbon.inbound.endpoint.protocol.websocket.management.WebsocketEndpointManager;

public class InboundWebsocketListener
implements InboundRequestProcessor {
    private static final Log log = LogFactory.getLog(InboundWebsocketListener.class);
    private String name;
    private int port;
    private InboundProcessorParams processorParams;

    public InboundWebsocketListener(InboundProcessorParams params) {
        this.processorParams = params;
        String portParam = params.getProperties().getProperty("inbound.ws.port");
        try {
            this.port = Integer.parseInt(portParam);
        }
        catch (NumberFormatException e) {
            this.handleException("Validation failed for the port parameter " + portParam, e);
        }
        this.name = params.getName();
    }

    public void init() {
        int offsetPort = this.port + PersistenceUtils.getPortOffset((Properties)this.processorParams.getProperties());
        WebsocketEndpointManager.getInstance().startEndpoint(offsetPort, this.name, this.processorParams);
    }

    public void destroy() {
        int offsetPort = this.port + PersistenceUtils.getPortOffset((Properties)this.processorParams.getProperties());
        WebsocketEndpointManager.getInstance().closeEndpoint(offsetPort);
    }

    protected void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    protected void destoryInbound() {
        if (this.processorParams.getSynapseEnvironment() != null) {
            Collection inboundEndpoints = this.processorParams.getSynapseEnvironment().getSynapseConfiguration().getInboundEndpoints();
            for (InboundEndpoint inboundEndpoint : inboundEndpoints) {
                if (!inboundEndpoint.getName().equals(this.name)) continue;
                this.processorParams.getSynapseEnvironment().getSynapseConfiguration().removeInboundEndpoint(this.name);
                break;
            }
        }
    }
}

