/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.protocol.nats;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.wso2.carbon.inbound.endpoint.protocol.nats.CoreListener;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsInjectHandler;
import org.wso2.carbon.inbound.endpoint.protocol.nats.NatsMessageListener;
import org.wso2.carbon.inbound.endpoint.protocol.nats.StreamingListener;

public class NatsMessageConsumer {
    private static final Log log = LogFactory.getLog((String)NatsMessageConsumer.class.getName());
    private NatsInjectHandler injectHandler;
    private Properties natsProperties;
    private NatsMessageListener natsMessageListener;
    private String subject;
    private String inboundEndpointName;

    public NatsMessageConsumer(Properties natsProperties, String inboundEndpointName) {
        this.natsProperties = natsProperties;
        this.inboundEndpointName = inboundEndpointName;
        this.subject = natsProperties.getProperty("subject");
        if (this.subject == null) {
            throw new SynapseException("NATS subject cannot be null.");
        }
    }

    public void initializeMessageListener() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Create the NATS message listener.");
        }
        if (Boolean.parseBoolean(this.natsProperties.getProperty("nats.streaming"))) {
            this.natsMessageListener = new StreamingListener(this.subject, this.injectHandler, this.natsProperties);
            return;
        }
        this.natsMessageListener = new CoreListener(this.subject, this.injectHandler, this.natsProperties);
    }

    public void initializeConsumer() throws IOException, InterruptedException, TimeoutException {
        this.natsMessageListener.initializeConsumer(this.inboundEndpointName);
    }

    public void closeConnection() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closing NATS connection");
        }
        this.natsMessageListener.closeConnection();
    }

    public void registerHandler(NatsInjectHandler injectHandler) {
        this.injectHandler = injectHandler;
    }
}

