/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.inbound.endpoint.osgi.service;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.inbound.endpoint.osgi.service.InboundEndpointService;
import org.wso2.carbon.inbound.endpoint.osgi.service.InboundEndpointServiceImpl;
import org.wso2.carbon.inbound.endpoint.osgi.service.ServiceReferenceHolder;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="inbound.endpoint.service", immediate=true)
public class InboundEndpointServiceDSComponent {
    private static final Log log = LogFactory.getLog(InboundEndpointServiceDSComponent.class);

    @Activate
    protected void activate(ComponentContext ctx) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Activating Inbound Endpoint service....!");
        }
        BundleContext bndCtx = ctx.getBundleContext();
        bndCtx.registerService(InboundEndpointService.class.getName(), (Object)new InboundEndpointServiceImpl(), null);
    }

    @Deactivate
    protected void deactivate(ComponentContext compCtx) throws Exception {
    }

    @Reference(name="config.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService bound to the ESB initialization process");
        }
        ServiceReferenceHolder.getInstance().setConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConfigurationContextService unbound from the ESB environment");
        }
        ServiceReferenceHolder.getInstance().setConfigurationContextService(null);
    }
}

