/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.handler;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.endpoints.Endpoint;

public class EndpointHolder
implements Runnable {
    private static final Log log = LogFactory.getLog(EndpointHolder.class);
    private static EndpointHolder endpointHolder = new EndpointHolder();
    private static ConcurrentHashMap<String, EndpointRef> endpointHashMap = new ConcurrentHashMap(2);

    private EndpointHolder() {
        long interval = 2L;
        ScheduledExecutorService globalExecutorService = Executors.newSingleThreadScheduledExecutor();
        globalExecutorService.scheduleAtFixedRate(this, interval, interval, TimeUnit.HOURS);
    }

    public static EndpointHolder getInstance() {
        return endpointHolder;
    }

    private void cleanupMap() {
        long currentTime = System.currentTimeMillis();
        for (String key : new ArrayList(endpointHashMap.keySet())) {
            EndpointRef endpoint = endpointHashMap.get(key);
            if (endpoint == null) continue;
            long expirationTime = 1800000L;
            if (currentTime - endpoint.lastAccessTime <= expirationTime) continue;
            endpointHashMap.remove(key);
        }
    }

    public Endpoint getEndpoint(String endpoint) {
        if (endpointHashMap.get(endpoint) != null) {
            endpointHashMap.get(endpoint).lastAccessTime = System.currentTimeMillis();
            return endpointHashMap.get(endpoint).endpoint;
        }
        return null;
    }

    public void putEndpoint(String endpointKey, Endpoint endpoint) {
        endpointHashMap.put(endpointKey, new EndpointRef(endpoint));
    }

    public boolean containsEndpoint(String endpoint) {
        return endpointHashMap.containsKey(endpoint);
    }

    @Override
    public void run() {
        try {
            this.cleanupMap();
        }
        catch (Exception e) {
            log.warn((Object)("Error occurred while cleaning up Endpoint map, Error - " + e.getMessage()), (Throwable)e);
        }
    }

    private static class EndpointRef {
        private Endpoint endpoint;
        private long lastAccessTime;

        EndpointRef(Endpoint endpoint) {
            this.endpoint = endpoint;
        }
    }
}

