/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.handler;

import java.util.Map;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.rest.Handler;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;

public class RESTBasicAuthHandler
implements Handler {
    private static final Log log = LogFactory.getLog(RESTBasicAuthHandler.class);

    public boolean handleRequest(org.apache.synapse.MessageContext messageContext) {
        MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
        Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
        if (headers instanceof Map) {
            Map headersMap = (Map)headers;
            if (headersMap.get("Authorization") == null) {
                headersMap.clear();
                axis2MessageContext.setProperty("HTTP_SC", (Object)401);
                headersMap.put("WWW_Authenticate", "Basic realm=\"WSO2 EI\"");
                axis2MessageContext.setProperty("NO_ENTITY_BODY", (Object)true);
                messageContext.setProperty("RESPONSE", (Object)"true");
                messageContext.setTo(null);
                Axis2Sender.sendBack((org.apache.synapse.MessageContext)messageContext);
                return false;
            }
            String credentials = (String)headersMap.get("Authorization");
            if (this.processSecurity(credentials)) {
                return true;
            }
            headersMap.clear();
            axis2MessageContext.setProperty("HTTP_SC", (Object)403);
            axis2MessageContext.setProperty("NO_ENTITY_BODY", (Object)true);
            messageContext.setProperty("RESPONSE", (Object)"true");
            messageContext.setTo(null);
            Axis2Sender.sendBack((org.apache.synapse.MessageContext)messageContext);
            return false;
        }
        return false;
    }

    public boolean handleResponse(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    public void addProperty(String s, Object o) {
    }

    public Map getProperties() {
        return null;
    }

    private boolean processSecurity(String credentials) {
        try {
            if (credentials.startsWith("Basic ")) {
                credentials = credentials.replaceAll("Basic ", "");
            }
            String decodedCredentials = new String(new Base64().decode(credentials.getBytes()));
            String[] details = decodedCredentials.split(":");
            String username = details[0];
            String password = details[1];
            UserRealm realm = (UserRealm)CarbonContext.getThreadLocalCarbonContext().getUserRealm();
            UserStoreManager userStoreManager = realm.getUserStoreManager();
            return userStoreManager.authenticate(username, (Object)password);
        }
        catch (UserStoreException e) {
            log.error((Object)"Error in authenticating user", (Throwable)e);
            return false;
        }
    }
}

