/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.util.XMLUtils;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.wso2.carbon.base.CarbonBaseUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;
import org.wso2.carbon.core.multitenancy.utils.TenantAxisUtils;
import org.wso2.carbon.integrator.core.handler.EndpointHolder;
import org.wso2.carbon.integrator.core.internal.IntegratorComponent;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.utils.ConfigurationContextService;
import org.wso2.carbon.webapp.mgt.WebApplication;
import org.wso2.carbon.webapp.mgt.WebApplicationsHolder;
import org.wso2.carbon.webapp.mgt.utils.WebAppUtils;

public class Utils {
    private static OMFactory fac = OMAbstractFactory.getOMFactory();
    private static final QName ENDPOINT_Q = new QName("http://ws.apache.org/ns/synapse", "endpoint");
    private static final QName ADDRESS_Q = new QName("http://ws.apache.org/ns/synapse", "address");
    private static OMElement endpoint = fac.createOMElement(ENDPOINT_Q);
    private static OMElement address = fac.createOMElement(ADDRESS_Q);
    private static OMElement axis2Config;

    public static int getProtocolPort(String protocol) {
        CarbonTomcatService webAppAdminService = IntegratorComponent.getCarbonTomcatService();
        if (webAppAdminService == null) {
            throw new RuntimeException("CarbonTomcatService service is not available.");
        }
        return webAppAdminService.getPort(protocol);
    }

    public static WebApplication getStartedWebapp(String path) {
        Map webApplicationsHolderMap = WebAppUtils.getAllWebappHolders((ConfigurationContext)CarbonConfigurationContextFactory.getConfigurationContext());
        for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
            for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
                if (!path.contains(webApplication.getContextName())) continue;
                WebApplication matchedWebApplication = webApplication;
                return matchedWebApplication;
            }
        }
        return null;
    }

    public static WebApplication getStartedTenantWebapp(String tenantDomain, String path) {
        ConfigurationContextService contextService = IntegratorComponent.getContextService();
        if (null != contextService) {
            ConfigurationContext configContext = contextService.getServerConfigContext();
            ConfigurationContext tenantContext = TenantAxisUtils.getTenantConfigurationContext((String)tenantDomain, (ConfigurationContext)configContext);
            Map webApplicationsHolderMap = WebAppUtils.getAllWebappHolders((ConfigurationContext)tenantContext);
            for (WebApplicationsHolder webApplicationsHolder : webApplicationsHolderMap.values()) {
                for (WebApplication webApplication : webApplicationsHolder.getStartedWebapps().values()) {
                    if (!path.contains(webApplication.getContextName())) continue;
                    WebApplication matchedWebApplication = webApplication;
                    return matchedWebApplication;
                }
            }
        }
        return null;
    }

    private static AxisService getTenantAxisService(String tenant, String serviceURL) throws AxisFault {
        ConfigurationContextService contextService = IntegratorComponent.getContextService();
        if (null != contextService) {
            ConfigurationContext configContext = contextService.getServerConfigContext();
            String[] urlparts = serviceURL.split("/");
            ConfigurationContext tenantContext = TenantAxisUtils.getTenantConfigurationContext((String)tenant, (ConfigurationContext)configContext);
            AxisService tenantAxisService = tenantContext.getAxisConfiguration().getService(urlparts[1]);
            if (tenantAxisService == null) {
                AxisServiceGroup axisServiceGroup = tenantContext.getAxisConfiguration().getServiceGroup(urlparts[1]);
                if (axisServiceGroup != null) {
                    return axisServiceGroup.getService(urlparts[2]);
                }
                return tenantContext.getAxisConfiguration().getService(urlparts[2]);
            }
            return tenantAxisService;
        }
        return null;
    }

    public static String getHostname(String host) {
        return host.split(":")[0];
    }

    public static String getContext(String uri) {
        String[] temp = uri.split("/");
        if (temp.length >= 2) {
            return "/".concat(temp[1]).toLowerCase(Locale.getDefault());
        }
        return null;
    }

    private static String getUniqueRequestID(String uri) {
        String input = uri + System.getProperty("wso2carbon.start.time");
        return UUID.nameUUIDFromBytes(input.getBytes(Charset.defaultCharset())).toString();
    }

    public static String getDSSJsonBuilder() throws IOException, XMLStreamException {
        String dssJsonBuilder = Utils.getPropertyFromAxisConf("dsJsonBuilder");
        if (dssJsonBuilder == null) {
            return "org.apache.axis2.json.gson.JsonBuilder";
        }
        return dssJsonBuilder;
    }

    public static Endpoint createEndpoint(String addressURI, SynapseEnvironment environment) {
        if (EndpointHolder.getInstance().getEndpoint(addressURI) != null) {
            return EndpointHolder.getInstance().getEndpoint(addressURI);
        }
        address.addAttribute("uri", addressURI, null);
        endpoint.addChild((OMNode)address);
        Endpoint ep = EndpointFactory.getEndpointFromElement((OMElement)endpoint, (boolean)true, null);
        ep.init(environment);
        EndpointHolder.getInstance().putEndpoint(addressURI, ep);
        return ep;
    }

    public static String getPassThroughJsonBuilder() throws IOException, XMLStreamException {
        String psJsonBuilder = Utils.getPropertyFromAxisConf("passthruJsonBuilder");
        if (psJsonBuilder == null) {
            return "org.apache.synapse.commons.json.JsonStreamBuilder";
        }
        return psJsonBuilder;
    }

    public static String getDSSJsonFormatter() throws IOException, XMLStreamException {
        String dssJsonFormatter = Utils.getPropertyFromAxisConf("dsJsonFormatter");
        if (dssJsonFormatter == null) {
            return "org.apache.axis2.json.gson.JsonFormatter";
        }
        return dssJsonFormatter;
    }

    public static String getPassThroughJsonFormatter() throws IOException, XMLStreamException {
        String psJsonFormatter = Utils.getPropertyFromAxisConf("passthruJsonFormatter");
        if (psJsonFormatter == null) {
            return "org.apache.synapse.commons.json.JsonStreamFormatter";
        }
        return psJsonFormatter;
    }

    private static String getPassThruHttpPort() {
        return CarbonConfigurationContextFactory.getConfigurationContext().getAxisConfiguration().getTransportIn("http").getParameter("port").getValue().toString();
    }

    private static String getPassThruHttpsPort() {
        return CarbonConfigurationContextFactory.getConfigurationContext().getAxisConfiguration().getTransportIn("https").getParameter("port").getValue().toString();
    }

    static boolean validateHeader(String key, String uri) {
        String input = uri + System.getProperty("wso2carbon.start.time");
        return UUID.nameUUIDFromBytes(input.getBytes(Charset.defaultCharset())).toString().equals(key);
    }

    public static void setIntegratorHeader(org.apache.synapse.MessageContext synCtx, String uri) {
        HashMap<String, String> headersMap;
        Axis2MessageContext axis2smc = (Axis2MessageContext)synCtx;
        MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
        Object headers = axis2MessageCtx.getProperty("TRANSPORT_HEADERS");
        if (headers != null && headers instanceof Map) {
            headersMap = (HashMap<String, String>)headers;
            headersMap.put("Integrator_header", Utils.getUniqueRequestID(uri));
        }
        if (headers == null) {
            headersMap = new HashMap<String, String>();
            headersMap.put("Integrator_header", Utils.getUniqueRequestID(uri));
            axis2MessageCtx.setProperty("TRANSPORT_HEADERS", headersMap);
        }
    }

    public static boolean isDataService(MessageContext messageContext) throws AxisFault {
        AxisService axisService = messageContext.getAxisService();
        if (axisService != null) {
            URL file = axisService.getFileName();
            if (file != null) {
                String filePath = file.getPath();
                return filePath.endsWith(".dbs");
            }
        } else {
            return Utils.isTenantDataService(messageContext);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTenantDataService(MessageContext messageContext) throws AxisFault {
        String url = (String)messageContext.getProperty("TransportInURL");
        if (url != null && url.contains(messageContext.getConfigurationContext().getServicePath() + "/t/")) {
            String tenantDomain = TenantAxisUtils.getTenantDomain((String)url);
            try {
                URL file;
                PrivilegedCarbonContext.startTenantFlow();
                PrivilegedCarbonContext privilegedCarbonContext = PrivilegedCarbonContext.getThreadLocalCarbonContext();
                privilegedCarbonContext.setTenantDomain(tenantDomain, true);
                url = url.substring(url.indexOf(tenantDomain));
                AxisService axisService = Utils.getTenantAxisService(tenantDomain, url);
                if (axisService != null && (file = axisService.getFileName()) != null) {
                    String filePath = file.getPath();
                    boolean bl = filePath.endsWith(".dbs");
                    return bl;
                }
            }
            finally {
                PrivilegedCarbonContext.endTenantFlow();
            }
        }
        return false;
    }

    public static void rewriteLocationHeader(String location, org.apache.synapse.MessageContext messageContext) {
        if (location.contains(":")) {
            String[] tmp = location.split(":");
            if (tmp.length <= 2) {
                return;
            }
            String protocol = tmp[0];
            String host = null;
            for (String tmpname : tmp[1].split("/")) {
                if (tmpname.isEmpty()) continue;
                host = tmpname;
                break;
            }
            String port = null;
            String newPort = "http".equals(protocol) ? Utils.getPassThruHttpPort() : Utils.getPassThruHttpsPort();
            if (tmp.length > 2) {
                port = tmp[2].substring(0, tmp[2].indexOf("/"));
            }
            String oldEndpoint = protocol + "://" + host + ":" + port;
            if (EndpointHolder.getInstance().containsEndpoint(oldEndpoint)) {
                location = location.replace(port, newPort);
                Object headers = ((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
                if (headers instanceof TreeMap) {
                    ((TreeMap)headers).put("Location", location);
                }
            }
        }
    }

    public static boolean isStatefulService(AxisService axisService) {
        Parameter parameter = axisService.getParameter("adminService");
        return parameter != null && "true".equals(parameter.getValue()) || "transportsession".equals(axisService.getScope());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getPropertyFromAxisConf(String parameter) throws IOException, XMLStreamException {
        try (FileInputStream file = new FileInputStream(Paths.get(CarbonBaseUtils.getCarbonConfigDirPath(), "axis2", "axis2.xml").toString());){
            if (axis2Config == null) {
                OMElement element = (OMElement)XMLUtils.toOM((InputStream)file);
                element.build();
                axis2Config = element;
            }
            Iterator parameters = axis2Config.getChildrenWithName(new QName("parameter"));
            while (parameters.hasNext()) {
                OMElement parameterElement = (OMElement)parameters.next();
                if (!parameter.equals(parameterElement.getAttribute(new QName("name")).getAttributeValue())) continue;
                String string = parameterElement.getText();
                return string;
            }
            String string = null;
            return string;
        }
    }
}

