/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.handler;

import java.util.Set;
import java.util.TreeMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.AbstractSynapseHandler;
import org.apache.synapse.SynapseException;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.mediators.builtin.SendMediator;
import org.apache.synapse.transport.passthru.core.PassThroughSenderManager;
import org.apache.synapse.util.logging.LoggingUtils;
import org.wso2.carbon.integrator.core.Utils;
import org.wso2.carbon.webapp.mgt.WebApplication;

public class IntegratorSynapseHandler
extends AbstractSynapseHandler {
    private static final Log log = LogFactory.getLog(IntegratorSynapseHandler.class);
    private SendMediator sendMediator;
    private PassThroughSenderManager passThroughSenderManager = PassThroughSenderManager.getInstance();
    private static final String MESSAGE_DISPATCHED = "MessageDispatched";
    private static final String RESPONSE_WRITTEN = "RESPONSE_WRITTEN";

    public IntegratorSynapseHandler() {
        this.sendMediator = new SendMediator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleRequestInFlow(org.apache.synapse.MessageContext messageContext) {
        boolean isPreserveHeadersContained = false;
        try {
            String uri22;
            WebApplication webApplication;
            MessageContext axis2MessageContext = ((Axis2MessageContext)messageContext).getAxis2MessageContext();
            Object isODataService = axis2MessageContext.getProperty("IsODataService");
            if (axis2MessageContext.getProperty("TransportInURL") != null && isODataService != null && (webApplication = Utils.getStartedWebapp(uri22 = axis2MessageContext.getProperty("TransportInURL").toString())) != null) {
                String protocol = (String)messageContext.getProperty("TRANSPORT_IN_NAME");
                Object headers = axis2MessageContext.getProperty("TRANSPORT_HEADERS");
                if (headers instanceof TreeMap) {
                    String host = Utils.getHostname((String)((TreeMap)headers).get("Host"));
                    isPreserveHeadersContained = true;
                    String endpoint = protocol + "://" + host + ":" + Utils.getProtocolPort(protocol);
                    boolean bl = this.dispatchMessage(endpoint, uri22, messageContext);
                    return bl;
                }
            }
            boolean uri22 = true;
            return uri22;
        }
        catch (Exception e) {
            this.handleException("Error occurred in integrator handler.", e, messageContext);
            boolean bl = true;
            return bl;
        }
        finally {
            block17: {
                if (isPreserveHeadersContained && this.passThroughSenderManager != null && this.passThroughSenderManager.getSharedPassThroughHttpSender() != null) {
                    try {
                        this.passThroughSenderManager.getSharedPassThroughHttpSender().removePreserveHttpHeader("User-Agent");
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        if (!log.isDebugEnabled()) break block17;
                        log.debug((Object)"ArrayIndexOutOfBoundsException exception occurred, when removing preserve headers.");
                    }
                }
            }
        }
    }

    public boolean handleRequestOutFlow(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    public boolean handleResponseInFlow(org.apache.synapse.MessageContext messageContext) {
        if ("true".equals(messageContext.getProperty(MESSAGE_DISPATCHED))) {
            String locationHeader;
            Set keySet = messageContext.getPropertyKeySet();
            keySet.remove(MESSAGE_DISPATCHED);
            Object headers = ((Axis2MessageContext)messageContext).getAxis2MessageContext().getProperty("TRANSPORT_HEADERS");
            if (headers instanceof TreeMap && (locationHeader = (String)((TreeMap)headers).get("Location")) != null) {
                Utils.rewriteLocationHeader(locationHeader, messageContext);
            }
            messageContext.setTo(null);
            messageContext.setResponse(true);
            Axis2MessageContext axis2smc = (Axis2MessageContext)messageContext;
            MessageContext axis2MessageCtx = axis2smc.getAxis2MessageContext();
            axis2MessageCtx.getOperationContext().setProperty(RESPONSE_WRITTEN, (Object)"SKIP");
            Axis2Sender.sendBack((org.apache.synapse.MessageContext)messageContext);
            return false;
        }
        return true;
    }

    public boolean handleResponseOutFlow(org.apache.synapse.MessageContext messageContext) {
        return true;
    }

    private void handleException(String msg, Exception e, org.apache.synapse.MessageContext msgContext) {
        log.error((Object)LoggingUtils.getFormattedLog((org.apache.synapse.MessageContext)msgContext, (Object)msg), (Throwable)e);
        if (msgContext.getServiceLog() != null) {
            msgContext.getServiceLog().error((Object)msg, (Throwable)e);
        }
        throw new SynapseException(msg, (Throwable)e);
    }

    private void setREST_URL_POSTFIX(MessageContext messageContext, String to) {
        if (messageContext.getProperty("REST_URL_POSTFIX") != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("message's REST_URL_POSTFIX is changing from " + messageContext.getProperty("REST_URL_POSTFIX") + " to " + to));
            }
            messageContext.setProperty("REST_URL_POSTFIX", (Object)to);
        }
    }

    private boolean dispatchMessage(String endpoint, String uri, org.apache.synapse.MessageContext messageContext) {
        block4: {
            if (this.passThroughSenderManager != null && this.passThroughSenderManager.getSharedPassThroughHttpSender() != null) {
                try {
                    this.passThroughSenderManager.getSharedPassThroughHttpSender().addPreserveHttpHeader("User-Agent");
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"ArrayIndexOutOfBoundsException exception occurred, when adding preserve headers.");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dispatching message to " + uri));
        }
        messageContext.setProperty(MESSAGE_DISPATCHED, (Object)"true");
        Utils.setIntegratorHeader(messageContext, uri);
        this.setREST_URL_POSTFIX(((Axis2MessageContext)messageContext).getAxis2MessageContext(), uri);
        this.sendMediator.setEndpoint(Utils.createEndpoint(endpoint, messageContext.getEnvironment()));
        return this.sendMediator.mediate(messageContext);
    }
}

