/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.json;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.integrator.core.Utils;

public class JsonStreamFormatter
implements MessageFormatter {
    private Method synapseFormatterGetBytesMethod;
    private Method axis2GsonFormatterGetBytesMethod;
    private Method synapseFormatterWriteToMethod;
    private Method axis2GsonFormatterWriteToMethod;
    private Method synapseFormatterGetContentTypeMethod;
    private Method axis2GsonFormatterGetContentTypeMethod;
    private Method synapseFormatterGetTargetAddressMethod;
    private Method axis2GsonFormatterGetTargetAddressMethod;
    private Method synapseFormatterFormatSOAPActionMethod;
    private Method axis2GsonFormatterFormatSOAPActionMethod;
    private Object synapseFormatter;
    private Object axis2GsonFormatter;
    private static final Log logger = LogFactory.getLog((String)JsonStreamFormatter.class.getName());

    public JsonStreamFormatter() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, IOException, XMLStreamException {
        Class<?> synapseFormatterClass = JsonStreamFormatter.class.getClassLoader().loadClass(Utils.getPassThroughJsonFormatter());
        this.synapseFormatter = synapseFormatterClass.newInstance();
        this.synapseFormatterGetBytesMethod = synapseFormatterClass.getMethod("getBytes", MessageContext.class, OMOutputFormat.class);
        this.synapseFormatterWriteToMethod = synapseFormatterClass.getMethod("writeTo", MessageContext.class, OMOutputFormat.class, OutputStream.class, Boolean.TYPE);
        this.synapseFormatterGetContentTypeMethod = synapseFormatterClass.getMethod("getContentType", MessageContext.class, OMOutputFormat.class, String.class);
        this.synapseFormatterGetTargetAddressMethod = synapseFormatterClass.getMethod("getTargetAddress", MessageContext.class, OMOutputFormat.class, URL.class);
        this.synapseFormatterFormatSOAPActionMethod = synapseFormatterClass.getMethod("formatSOAPAction", MessageContext.class, OMOutputFormat.class, String.class);
        Class<?> axis2GsonFormatterClass = JsonStreamFormatter.class.getClassLoader().loadClass(Utils.getDSSJsonFormatter());
        this.axis2GsonFormatter = axis2GsonFormatterClass.newInstance();
        this.axis2GsonFormatterGetBytesMethod = axis2GsonFormatterClass.getMethod("getBytes", MessageContext.class, OMOutputFormat.class);
        this.axis2GsonFormatterWriteToMethod = axis2GsonFormatterClass.getMethod("writeTo", MessageContext.class, OMOutputFormat.class, OutputStream.class, Boolean.TYPE);
        this.axis2GsonFormatterGetContentTypeMethod = axis2GsonFormatterClass.getMethod("getContentType", MessageContext.class, OMOutputFormat.class, String.class);
        this.axis2GsonFormatterGetTargetAddressMethod = axis2GsonFormatterClass.getMethod("getTargetAddress", MessageContext.class, OMOutputFormat.class, URL.class);
        this.axis2GsonFormatterFormatSOAPActionMethod = axis2GsonFormatterClass.getMethod("formatSOAPAction", MessageContext.class, OMOutputFormat.class, String.class);
    }

    public byte[] getBytes(MessageContext messageContext, OMOutputFormat omOutputFormat) throws AxisFault {
        try {
            if (Utils.isDataService(messageContext)) {
                return (byte[])this.axis2GsonFormatterGetBytesMethod.invoke(this.axis2GsonFormatter, messageContext, omOutputFormat);
            }
            return (byte[])this.synapseFormatterGetBytesMethod.invoke(this.synapseFormatter, messageContext, omOutputFormat);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error((Object)"Error occurred while generating bytes for application/json", (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public void writeTo(MessageContext messageContext, OMOutputFormat omOutputFormat, OutputStream outputStream, boolean b) throws AxisFault {
        try {
            if (Utils.isDataService(messageContext)) {
                this.axis2GsonFormatterWriteToMethod.invoke(this.axis2GsonFormatter, messageContext, omOutputFormat, outputStream, b);
            } else {
                this.synapseFormatterWriteToMethod.invoke(this.synapseFormatter, messageContext, omOutputFormat, outputStream, b);
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error((Object)"Error occurred while writing to application/json", (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public String getContentType(MessageContext messageContext, OMOutputFormat omOutputFormat, String s) {
        try {
            if (Utils.isDataService(messageContext)) {
                return (String)this.axis2GsonFormatterGetContentTypeMethod.invoke(this.axis2GsonFormatter, messageContext, omOutputFormat, s);
            }
            return (String)this.synapseFormatterGetContentTypeMethod.invoke(this.synapseFormatter, messageContext, omOutputFormat, s);
        }
        catch (IllegalAccessException | InvocationTargetException | AxisFault e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat omOutputFormat, URL url) throws AxisFault {
        try {
            if (Utils.isDataService(messageContext)) {
                return (URL)this.axis2GsonFormatterGetTargetAddressMethod.invoke(this.axis2GsonFormatter, messageContext, omOutputFormat, url);
            }
            return (URL)this.synapseFormatterGetTargetAddressMethod.invoke(this.synapseFormatter, messageContext, omOutputFormat, url);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error((Object)"Error occurred while retrieving target address for application/json", (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }

    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat omOutputFormat, String s) {
        try {
            if (Utils.isDataService(messageContext)) {
                return (String)this.axis2GsonFormatterFormatSOAPActionMethod.invoke(this.axis2GsonFormatter, messageContext, omOutputFormat, s);
            }
            return (String)this.synapseFormatterFormatSOAPActionMethod.invoke(this.synapseFormatter, messageContext, omOutputFormat, s);
        }
        catch (IllegalAccessException | InvocationTargetException | AxisFault e) {
            logger.error((Object)e.getMessage());
            throw new RuntimeException(e.getMessage());
        }
    }
}

