/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.handler;

import java.io.IOException;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.dispatchers.HTTPLocationBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIBasedDispatcher;
import org.apache.axis2.dispatchers.RequestURIBasedServiceDispatcher;
import org.apache.axis2.dispatchers.RequestURIOperationDispatcher;
import org.apache.axis2.engine.AbstractDispatcher;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.util.JavaUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.core.axis2.SynapseDispatcher;
import org.apache.synapse.transport.passthru.util.RelayUtils;
import org.wso2.carbon.integrator.core.Utils;
import org.wso2.carbon.integrator.core.handler.IntegratorSynapseHandler;
import org.wso2.carbon.webapp.mgt.WebApplication;

public class IntegratorStatefulHandler
extends AbstractDispatcher {
    private static final String BUILDER_INVOKED = "message.builder.invoked";
    private static final String NAME = "IntegratorStatefulHandler";
    private static final Log log = LogFactory.getLog(IntegratorSynapseHandler.class);
    private SynapseDispatcher synapseDispatcher = new SynapseDispatcher();
    private RequestURIBasedServiceDispatcher rubsd = new RequestURIBasedServiceDispatcher();
    private static RequestURIOperationDispatcher requestURIOperationDispatcher = new RequestURIOperationDispatcher();
    private static HTTPLocationBasedDispatcher httpLocationBasedDispatcher = new HTTPLocationBasedDispatcher();
    private static RequestURIBasedDispatcher requestDispatcher = new RequestURIBasedDispatcher();

    public AxisOperation findOperation(AxisService axisService, MessageContext messageContext) throws AxisFault {
        return null;
    }

    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        String uri = (String)msgctx.getProperty("TransportInURL");
        if (msgctx.getAxisService() == null) {
            msgctx.setAxisService(this.rubsd.findService(msgctx));
        }
        if (msgctx.getProperty("transport.http.servletRequest") == null && uri != null && uri.contains("/odata/")) {
            WebApplication webApplication = Utils.getStartedWebapp(msgctx.getProperty("TransportInURL").toString());
            if (webApplication != null) {
                msgctx.setProperty("IsODataService", (Object)true);
                this.setSynapseContext(msgctx, msgctx.getAxisService());
            }
        } else if (Utils.isDataService(msgctx)) {
            try {
                String acceptHeader;
                Map transportHeaders;
                IntegratorStatefulHandler.dispatchAndVerify(msgctx);
                if (!Boolean.TRUE.equals(msgctx.getProperty(BUILDER_INVOKED))) {
                    RelayUtils.buildMessage((MessageContext)msgctx);
                    msgctx.setProperty(BUILDER_INVOKED, (Object)Boolean.TRUE);
                }
                String type = null;
                AxisConfiguration configuration = msgctx.getConfigurationContext().getAxisConfiguration();
                Object contentNegotiation = configuration.getParameterValue("httpContentNegotiation");
                if (JavaUtils.isTrueExplicitly((Object)contentNegotiation) && (transportHeaders = (Map)msgctx.getProperty("TRANSPORT_HEADERS")) != null && (acceptHeader = (String)transportHeaders.get("Accept")) != null) {
                    String[] headers;
                    int index = acceptHeader.indexOf(";");
                    if (index > 0) {
                        acceptHeader = acceptHeader.substring(0, index);
                    }
                    for (String header : headers = acceptHeader.split(",")) {
                        String accept = header.trim();
                        if ("text/xml".equals(accept) || configuration.getMessageFormatter(accept) == null) continue;
                        type = header;
                        break;
                    }
                }
                if (type != null) {
                    msgctx.setProperty("messageType", type);
                }
            }
            catch (IOException e) {
                throw new AxisFault("I/O  Exception occured while building the data service request", (Throwable)e);
            }
            catch (XMLStreamException e) {
                throw new AxisFault("Exception occured while building the data service request as an XML", (Throwable)e);
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }

    private void setSynapseContext(MessageContext messageContext, AxisService originalAxisService) throws AxisFault {
        AxisService axisService = this.synapseDispatcher.findService(messageContext);
        if (log.isDebugEnabled()) {
            log.debug((Object)("AxisService is changing from " + originalAxisService.getName() + " to " + axisService.getName()));
        }
        messageContext.setAxisService(axisService);
        messageContext.setAxisOperation(this.synapseDispatcher.findOperation(messageContext.getAxisService(), messageContext));
    }

    public AxisService findService(MessageContext messageContext) throws AxisFault {
        return this.rubsd.findService(messageContext);
    }

    public void initDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    private static void dispatchAndVerify(MessageContext msgContext) throws AxisFault {
        requestDispatcher.invoke(msgContext);
        AxisService axisService = msgContext.getAxisService();
        if (axisService != null) {
            AxisOperation axisOperation;
            httpLocationBasedDispatcher.invoke(msgContext);
            if (msgContext.getAxisOperation() == null) {
                requestURIOperationDispatcher.invoke(msgContext);
            }
            if ((axisOperation = msgContext.getAxisOperation()) != null) {
                AxisEndpoint axisEndpoint = (AxisEndpoint)msgContext.getProperty("endpoint");
                if (axisEndpoint != null) {
                    AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisEndpoint.getBinding().getChild((Object)axisOperation.getName());
                    msgContext.setProperty("AxisBindingOperation", (Object)axisBindingOperation);
                }
                msgContext.setAxisOperation(axisOperation);
            }
        }
    }
}

