/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.json.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GSONUtils {
    private static final Log log = LogFactory.getLog(GSONUtils.class);

    public static Map gsonJsonObjectToMap(JsonElement jsonElement) {
        LinkedHashMap<String, Object> gsonMap = new LinkedHashMap<String, Object>();
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Set entrySet = jsonObject.entrySet();
            for (Map.Entry entry : entrySet) {
                if (((JsonElement)entry.getValue()).isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = ((JsonElement)entry.getValue()).getAsJsonPrimitive();
                    if (jsonPrimitive.isString()) {
                        gsonMap.put((String)entry.getKey(), jsonPrimitive.getAsString());
                        continue;
                    }
                    if (jsonPrimitive.isBoolean()) {
                        gsonMap.put((String)entry.getKey(), jsonPrimitive.getAsBoolean());
                        continue;
                    }
                    if (jsonPrimitive.isNumber()) {
                        gsonMap.put((String)entry.getKey(), jsonPrimitive.getAsNumber());
                        continue;
                    }
                    log.warn((Object)("Unknown JsonPrimitive type found : " + jsonPrimitive.toString()));
                    continue;
                }
                if (((JsonElement)entry.getValue()).isJsonObject()) {
                    gsonMap.put((String)entry.getKey(), GSONUtils.gsonJsonObjectToMap((JsonElement)entry.getValue()));
                    continue;
                }
                if (((JsonElement)entry.getValue()).isJsonArray()) {
                    gsonMap.put((String)entry.getKey(), GSONUtils.gsonJsonArrayToObjectArray((JsonElement)((JsonElement)entry.getValue()).getAsJsonArray()));
                    continue;
                }
                gsonMap.put((String)entry.getKey(), null);
            }
        } else {
            log.error((Object)"Provided gson model does not represent json object");
        }
        return gsonMap;
    }

    public static Object[] gsonJsonArrayToObjectArray(JsonElement jsonElement) {
        ArrayList<Object> jsonArrayList = new ArrayList<Object>();
        if (jsonElement.isJsonArray()) {
            JsonArray jsonArray = jsonElement.getAsJsonArray();
            for (int i = 0; i < jsonArray.size(); ++i) {
                JsonElement arrayElement = jsonArray.get(i);
                if (arrayElement.isJsonPrimitive()) {
                    JsonPrimitive jsonPrimitive = arrayElement.getAsJsonPrimitive();
                    if (jsonPrimitive.isString()) {
                        jsonArrayList.add(jsonPrimitive.getAsString());
                        continue;
                    }
                    if (jsonPrimitive.isBoolean()) {
                        jsonArrayList.add(jsonPrimitive.getAsBoolean());
                        continue;
                    }
                    if (jsonPrimitive.isNumber()) {
                        jsonArrayList.add(jsonPrimitive.getAsNumber());
                        continue;
                    }
                    log.warn((Object)("Unknown JsonPrimitive type found : " + jsonPrimitive.toString()));
                    continue;
                }
                if (arrayElement.isJsonObject()) {
                    jsonArrayList.add(GSONUtils.gsonJsonObjectToMap(arrayElement));
                    continue;
                }
                if (arrayElement.isJsonArray()) {
                    jsonArrayList.add(GSONUtils.gsonJsonArrayToObjectArray((JsonElement)arrayElement.getAsJsonArray()));
                    continue;
                }
                jsonArrayList.add(null);
            }
        } else {
            log.error((Object)"Provided gson model does not represent json array");
        }
        return jsonArrayList.toArray();
    }
}

