/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.tomcat.api.CarbonTomcatService;
import org.wso2.carbon.utils.ConfigurationContextService;

@Component(name="org.wso2.carbon.integrator.core.internal.IntegratorComponent", immediate=true)
public class IntegratorComponent {
    private static final Log log = LogFactory.getLog(IntegratorComponent.class);
    private static ConfigurationContextService contextService;
    private static CarbonTomcatService carbonTomcatService;

    @Activate
    protected void activate(ComponentContext context) {
        log.debug((Object)"Activating Integrator component");
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        log.debug((Object)"Deactivating Integrator component");
    }

    @Reference(name="configuration.context.service", service=ConfigurationContextService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigurationContextService")
    protected void setConfigurationContextService(ConfigurationContextService contextService) {
        IntegratorComponent.setContextService(contextService);
    }

    protected static void setContextService(ConfigurationContextService contextService) {
        IntegratorComponent.contextService = contextService;
    }

    protected void unsetConfigurationContextService(ConfigurationContextService contextService) {
        IntegratorComponent.unsetConfigurationService();
    }

    protected static void unsetConfigurationService() {
        contextService = null;
    }

    protected static void unsetTomcatService() {
        carbonTomcatService = null;
    }

    protected static void setTomcatService(CarbonTomcatService carbonTomcatService) {
        IntegratorComponent.carbonTomcatService = carbonTomcatService;
    }

    @Reference(name="1..1", service=CarbonTomcatService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetCarbonTomcatService")
    protected void setCarbonTomcatService(CarbonTomcatService contextService) {
        IntegratorComponent.setTomcatService(contextService);
    }

    protected void unsetCarbonTomcatService(CarbonTomcatService contextService) {
        IntegratorComponent.unsetTomcatService();
    }

    public static CarbonTomcatService getCarbonTomcatService() {
        return carbonTomcatService;
    }

    public static ConfigurationContextService getContextService() {
        return contextService;
    }
}

