/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.integrator.core.json;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.integrator.core.Utils;

public class JsonStreamBuilder
implements Builder {
    private Method synapseBuilderProcessDocumentMethod;
    private Method axis2GsonBuilderProcessDocumentMethod;
    private Object synapseBuilder;
    private Object axis2GsonBuilder;
    private static final Log logger = LogFactory.getLog((String)JsonStreamBuilder.class.getName());

    public JsonStreamBuilder() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, IOException, XMLStreamException {
        Class<?> synapseBuilderClass = JsonStreamBuilder.class.getClassLoader().loadClass(Utils.getPassThroughJsonBuilder());
        this.synapseBuilder = synapseBuilderClass.newInstance();
        this.synapseBuilderProcessDocumentMethod = synapseBuilderClass.getMethod("processDocument", InputStream.class, String.class, MessageContext.class);
        Class<?> axis2GsonBuilderClass = JsonStreamBuilder.class.getClassLoader().loadClass(Utils.getDSSJsonBuilder());
        this.axis2GsonBuilder = axis2GsonBuilderClass.newInstance();
        this.axis2GsonBuilderProcessDocumentMethod = axis2GsonBuilderClass.getMethod("processDocument", InputStream.class, String.class, MessageContext.class);
    }

    public OMElement processDocument(InputStream inputStream, String s, MessageContext messageContext) throws AxisFault {
        try {
            if (Utils.isDataService(messageContext)) {
                return (OMElement)this.axis2GsonBuilderProcessDocumentMethod.invoke(this.axis2GsonBuilder, inputStream, s, messageContext);
            }
            return (OMElement)this.synapseBuilderProcessDocumentMethod.invoke(this.synapseBuilder, inputStream, s, messageContext);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            logger.error((Object)"Error occurred while processing document for application/json", (Throwable)e);
            throw new AxisFault(e.getMessage());
        }
    }
}

