/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.localentry.ui.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringReader;
import java.rmi.RemoteException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.localentry.stub.types.ConfigurationObject;
import org.wso2.carbon.localentry.stub.types.EntryData;
import org.wso2.carbon.localentry.stub.types.LocalEntryAdminServiceStub;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LocalEntryAdminClient {
    private LocalEntryAdminServiceStub stub;
    private static final Log log = LogFactory.getLog(LocalEntryAdminClient.class);
    public static final int LOCAL_ENTRIES_PER_PAGE = 10;

    public LocalEntryAdminClient(String cookie, String backendServerURL, ConfigurationContext configCtx) throws AxisFault {
        String serviceURL = backendServerURL + "LocalEntryAdmin";
        this.stub = new LocalEntryAdminServiceStub(configCtx, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
    }

    public EntryData[] getEntryData() throws Exception {
        EntryData[] data = null;
        try {
            data = this.stub.entryData();
        }
        catch (Exception e) {
            this.handleFault(e);
        }
        return data;
    }

    public EntryData[] getPaginatedEntryData(int pageNo) throws Exception {
        EntryData[] data = null;
        try {
            data = this.stub.paginatedEntryData(pageNo);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
        return data;
    }

    public int getEntryDataCount() throws Exception {
        int count = 0;
        try {
            count = this.stub.getEntryDataCount();
        }
        catch (Exception e) {
            this.handleFault(e);
        }
        return count;
    }

    public void saveEntry(String entry) throws Exception {
        try {
            this.stub.saveEntry(entry);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void addEntry(String entry) throws Exception {
        try {
            this.stub.addEntry(entry);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public void deleteEntry(String entry) throws Exception {
        try {
            this.stub.deleteEntry(entry);
        }
        catch (Exception e) {
            this.handleFault(e);
        }
    }

    public ConfigurationObject[] getDependents(String entry) throws Exception {
        try {
            ConfigurationObject[] dependents = this.stub.getDependents(entry);
            if (dependents != null && dependents.length > 0 && dependents[0] != null) {
                return dependents;
            }
        }
        catch (RemoteException e) {
            this.handleFault(e);
        }
        return null;
    }

    private void handleFault(Exception e) throws Exception {
        log.error((Object)e.getMessage(), (Throwable)e);
        throw e;
    }

    public static OMElement nonCoalescingStringToOm(String xmlStr) throws XMLStreamException {
        StringReader strReader = new StringReader(xmlStr);
        XMLInputFactory xmlInFac = XMLInputFactory.newInstance();
        xmlInFac.setProperty("javax.xml.stream.isCoalescing", false);
        XMLStreamReader parser = xmlInFac.createXMLStreamReader(strReader);
        StAXOMBuilder builder = new StAXOMBuilder(parser);
        return builder.getDocumentElement();
    }

    public static void checkForXXE(String xmlStr) throws Exception {
        DocumentBuilder documentBuilder = LocalEntryAdminClient.getSecuredDocumentBuilder(false);
        documentBuilder.parse(new ByteArrayInputStream(xmlStr.getBytes()));
    }

    private static DocumentBuilder getSecuredDocumentBuilder(boolean setIgnoreComments) throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringComments(setIgnoreComments);
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                throw new SAXException("Possible XML External Entity (XXE) attack. Skip resolving entity");
            }
        });
        return documentBuilder;
    }
}

