/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.configadmin;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.ConfigurationFactoryAndSerializerFinder;
import org.apache.synapse.config.xml.MultiXMLConfigurationSerializer;
import org.apache.synapse.config.xml.XMLConfigurationSerializer;
import org.wso2.carbon.base.ServerConfiguration;
import org.wso2.carbon.mediation.configadmin.ConfigurationInformation;
import org.wso2.carbon.mediation.configadmin.ConfigurationUpdater;
import org.wso2.carbon.mediation.configadmin.ConfigurationValidator;
import org.wso2.carbon.mediation.configadmin.ValidationError;
import org.wso2.carbon.mediation.configadmin.util.XMLPrettyPrinter;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationInitilizerException;
import org.wso2.carbon.mediation.initializer.configurations.ConfigurationManager;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ConfigAdmin
extends AbstractServiceBusAdmin {
    static final String PROP_REPORT_CDATA = "http://java.sun.com/xml/stream/properties/report-cdata-event";
    private static final Log log = LogFactory.getLog(ConfigAdmin.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getConfiguration() throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            ConfigurationFactoryAndSerializerFinder.getInstance();
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XMLConfigurationSerializer.serializeConfiguration((SynapseConfiguration)this.getSynapseConfiguration(), (OutputStream)stream);
            XMLInputFactory factory = XMLInputFactory.newInstance();
            if (factory.isPropertySupported(PROP_REPORT_CDATA)) {
                factory.setProperty(PROP_REPORT_CDATA, Boolean.TRUE);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(stream.toByteArray());
            XMLPrettyPrinter xmlPrettyPrinter = new XMLPrettyPrinter(byteArrayInputStream);
            String string = xmlPrettyPrinter.xmlFormatWithComments();
            return string;
        }
        catch (XMLStreamException e) {
            this.handleException("Error serializing the Synapse configuration : Error " + e.getMessage(), e);
        }
        catch (Exception e) {
            this.handleException("Error serializing the Synapse configuration : Error " + e.getMessage(), e);
        }
        finally {
            lock.unlock();
        }
        return "";
    }

    public ConfigurationInformation[] getConfigurationList() throws AxisFault {
        try {
            List list = this.getConfigurationManager().getConfigurationsList();
            ArrayList<ConfigurationInformation> configList = new ArrayList<ConfigurationInformation>();
            for (org.wso2.carbon.mediation.initializer.configurations.ConfigurationInformation info : list) {
                ConfigurationInformation configInfo = new ConfigurationInformation();
                configInfo.setActive(info.isActive());
                configInfo.setName(info.getName());
                configInfo.setDescription(info.getDescription());
                configList.add(configInfo);
            }
            return configList.toArray(new ConfigurationInformation[configList.size()]);
        }
        catch (ConfigurationInitilizerException e) {
            this.handleException("Failed to get the configurations list", (Exception)((Object)e));
            return null;
        }
    }

    public boolean deleteConfiguration(String name) throws AxisFault {
        UserRegistry registry = (UserRegistry)this.getConfigSystemRegistry();
        try {
            this.getConfigurationManager().delete(name);
        }
        catch (ConfigurationInitilizerException e) {
            this.handleException("Error deleting the configuration: " + name, (Exception)((Object)e));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConfiguration(OMElement configElement) throws AxisFault {
        Object error = null;
        Lock lock = this.getLock();
        try {
            MediationPersistenceManager pm;
            lock.lock();
            ConfigurationUpdater updater = new ConfigurationUpdater(this.getServerContextInformation(), this.getConfigContext(), this.getMediationPersistenceManager(), (UserRegistry)this.getConfigSystemRegistry());
            updater.update(configElement);
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && (pm = this.getMediationPersistenceManager()) != null) {
                pm.saveItem(null, 7);
            }
        }
        catch (Exception e) {
            this.handleException("Error while updating the Synapse configuration", e);
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    public ValidationError[] validateConfiguration(OMElement configElement) {
        String path;
        MultiXMLConfigurationSerializer serializer;
        MediationPersistenceManager pm;
        if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode")) && (pm = this.getMediationPersistenceManager()) != null && !(serializer = new MultiXMLConfigurationSerializer(path = this.getSynapseConfiguration().getPathToConfigFile())).isWritable()) {
            return new ValidationError[]{new ValidationError("Configuration Directory", "Locked by another process")};
        }
        ConfigurationValidator validator = new ConfigurationValidator();
        ValidationError[] errors = validator.validate(configElement);
        if (errors != null && errors.length > 0) {
            return errors;
        }
        return null;
    }

    public boolean create(String name, String description) throws AxisFault {
        try {
            this.getConfigurationManager().create(name, description);
            return true;
        }
        catch (ConfigurationInitilizerException e) {
            this.handleException("Couldn't initialize the new configuration", (Exception)((Object)e));
            return false;
        }
    }

    public boolean addExistingConfiguration(String name) throws AxisFault {
        try {
            this.getConfigurationManager().addExistingConfiguration(name);
            return true;
        }
        catch (ConfigurationInitilizerException e) {
            this.handleException("Failed to add the existing configuration: " + name, (Exception)((Object)e));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean activate(String name) throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            this.getConfigurationManager().activate(name);
        }
        catch (Exception e) {
            this.handleException("Error creating a new Synapse configuration", e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveConfigurationToDisk() throws AxisFault {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Saving configuration..");
        }
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration config = this.getSynapseConfiguration();
            FileOutputStream fos = new FileOutputStream(config.getPathToConfigFile());
            XMLConfigurationSerializer.serializeConfiguration((SynapseConfiguration)config, (OutputStream)fos);
            try {
                fos.close();
                org.apache.axis2.util.XMLPrettyPrinter.prettify((File)new File(config.getPathToConfigFile()));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)"Configuration saved to disk");
            }
            boolean bl = true;
            return bl;
        }
        catch (XMLStreamException e) {
            this.handleException("Could not save changes to disk." + e.getMessage() + " Check log for more details", e);
        }
        catch (FileNotFoundException e) {
            this.handleException("Could not locate the Synapse configuration file to save changes", e);
        }
        catch (SynapseException se) {
            this.handleException("Unable to update the Synapse configuration." + se.getMessage() + " Check log for more details", (Exception)((Object)se));
        }
        catch (Exception e) {
            this.handleException("Unable to update the Synapse configuration." + e.getMessage() + " Check log for more details", e);
        }
        finally {
            lock.unlock();
        }
        return false;
    }

    private ConfigurationManager getConfigurationManager() {
        return (ConfigurationManager)this.getConfigContext().getProperty("CONFIGURATION_MANAGER");
    }

    private String getParameter(String name) {
        String value = System.getProperty(name);
        if (value != null) {
            return value;
        }
        ServerConfiguration serverConfig = ServerConfiguration.getInstance();
        return serverConfig.getFirstProperty(name);
    }

    private void handleException(String msg, Exception e) throws AxisFault {
        log.error((Object)msg, (Throwable)e);
        throw new AxisFault(msg, (Throwable)e);
    }
}

