/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.configadmin;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.SynapsePropertiesLoader;
import org.apache.synapse.config.xml.EntryFactory;
import org.apache.synapse.config.xml.ProxyServiceFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.apache.synapse.config.xml.endpoints.EndpointFactory;
import org.apache.synapse.core.axis2.ProxyService;
import org.wso2.carbon.mediation.configadmin.ValidationError;

public class ConfigurationValidator {
    public ValidationError[] validate(OMElement element) {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        ArrayList<String> configSequenceList = new ArrayList<String>();
        if (!element.getQName().equals(XMLConfigConstants.DEFINITIONS_ELT)) {
            errors.add(this.newValidationError(element, "Top level element is invalid"));
        }
        Iterator itr = element.getChildren();
        while (itr.hasNext()) {
            Object o = itr.next();
            if (!(o instanceof OMElement)) continue;
            OMElement child = (OMElement)o;
            if (XMLConfigConstants.PROXY_ELT.equals(child.getQName())) {
                this.validateProxyService(child, errors);
                continue;
            }
            if (XMLConfigConstants.ENDPOINT_ELT.equals(child.getQName())) {
                this.validateEndpoint(child, errors);
                continue;
            }
            if (XMLConfigConstants.SEQUENCE_ELT.equals(child.getQName())) {
                String name = child.getAttributeValue(new QName("", "name"));
                if (configSequenceList.contains(name)) {
                    errors.add(this.newValidationError(child, "Sequence [" + name + "] name already existing"));
                    continue;
                }
                this.validateSequence(child, errors);
                configSequenceList.add(name);
                continue;
            }
            if (!XMLConfigConstants.ENTRY_ELT.equals(child.getQName())) continue;
            this.validateLocalEntry(child, errors);
        }
        if (errors.size() > 0) {
            return errors.toArray(new ValidationError[errors.size()]);
        }
        return null;
    }

    private void validateSequence(OMElement sequenceElement, List<ValidationError> errors) {
        try {
            new SequenceMediatorFactory().createMediator(sequenceElement, new Properties());
        }
        catch (Exception e) {
            errors.add(this.newValidationError(sequenceElement, e.getMessage()));
        }
    }

    private void validateProxyService(OMElement proxyElement, List<ValidationError> errors) {
        try {
            ProxyService proxy = ProxyServiceFactory.createProxy((OMElement)proxyElement, (Properties)new Properties());
            URI wsdl = proxy.getWsdlURI();
            if (wsdl != null && !this.testURL(wsdl.toString())) {
                errors.add(this.newValidationError(proxyElement, "WSDL URL is not accessible"));
            }
        }
        catch (Exception e) {
            errors.add(this.newValidationError(proxyElement, e.getMessage()));
        }
    }

    private void validateEndpoint(OMElement endpointElement, List<ValidationError> errors) {
        try {
            EndpointFactory.getEndpointFromElement((OMElement)endpointElement, (boolean)false, (Properties)new Properties());
        }
        catch (Exception e) {
            errors.add(this.newValidationError(endpointElement, e.getMessage()));
        }
    }

    private void validateLocalEntry(OMElement entryElement, List<ValidationError> errors) {
        try {
            EntryFactory.createEntry((OMElement)entryElement, (Properties)new Properties());
        }
        catch (Exception e) {
            errors.add(this.newValidationError(entryElement, e.getMessage()));
        }
    }

    private boolean testURL(String urlString) throws MalformedURLException {
        URL url = new URL(urlString);
        try {
            url.openStream();
            return true;
        }
        catch (IOException e) {
            String path = url.getPath();
            String synapseHome = SynapsePropertiesLoader.loadSynapseProperties().getProperty("synapse.home");
            if (synapseHome != null) {
                if (synapseHome.endsWith("/")) {
                    synapseHome = synapseHome.substring(0, synapseHome.lastIndexOf("/"));
                }
                url = new URL(url.getProtocol() + ":" + synapseHome + "/" + path);
                try {
                    url.openStream();
                    return true;
                }
                catch (IOException ex) {
                    return false;
                }
            }
            return false;
        }
    }

    private ValidationError newValidationError(OMElement element, String message) {
        String name = XMLConfigConstants.ENTRY_ELT.equals(element.getQName()) ? element.getAttributeValue(new QName("key")) : element.getAttributeValue(new QName("name"));
        String localName = element.getLocalName();
        name = name == null ? localName : name + " [" + localName.substring(0, 1).toUpperCase() + localName.substring(1) + "]";
        return new ValidationError(name, message);
    }
}

