/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.DirectedEdge;

class DependencyGraph {
    private static final Log log = LogFactory.getLog(DependencyGraph.class);
    private final Set<ConfigurationObject> vertices = new HashSet<ConfigurationObject>();
    private final Set<DirectedEdge> edges = new HashSet<DirectedEdge>();

    DependencyGraph() {
    }

    public boolean add(ConfigurationObject o) {
        if (o == null) {
            throw new NullPointerException("null objects cannot be added to the dependency graph");
        }
        return this.vertices.add(o);
    }

    public boolean remove(int type, String id) {
        ConfigurationObject o = this.find(type, id);
        if (o != null) {
            if (this.hasDependents(o)) {
                o.setType(6);
            } else {
                this.remove(o);
            }
        }
        return false;
    }

    private boolean remove(ConfigurationObject o) {
        if (this.vertices.remove(o)) {
            ArrayList<DirectedEdge> deletedEdges = new ArrayList<DirectedEdge>();
            for (DirectedEdge e : this.edges) {
                if (e.getStart() != o && e.getEnd() != o) continue;
                deletedEdges.add(e);
            }
            for (DirectedEdge e : deletedEdges) {
                this.edges.remove(e);
            }
            this.cleanupUnknownObjects();
            return true;
        }
        return false;
    }

    private void cleanupUnknownObjects() {
        ArrayList<ConfigurationObject> deletedVertices = new ArrayList<ConfigurationObject>();
        for (ConfigurationObject v : this.vertices) {
            if (v.getType() != 6) continue;
            boolean edgeFound = false;
            for (DirectedEdge e : this.edges) {
                if (e.getStart() != v && e.getEnd() != v) continue;
                edgeFound = true;
                break;
            }
            if (edgeFound) continue;
            deletedVertices.add(v);
        }
        for (ConfigurationObject v : deletedVertices) {
            this.vertices.remove(v);
        }
    }

    public boolean createEdge(ConfigurationObject start, ConfigurationObject end) {
        this.add(start);
        this.add(end);
        for (DirectedEdge e : this.edges) {
            if (e.getStart() != start || e.getEnd() != end) continue;
            return false;
        }
        this.edges.add(new DirectedEdge(start, end));
        if (log.isDebugEnabled()) {
            log.debug((Object)("Dependency detected: {" + start.getTypeName() + ":" + start.getId() + "} ---> {" + end.getTypeName() + ":" + end.getId() + "}, Tracking..."));
        }
        return true;
    }

    public ConfigurationObject find(int type, String Id) {
        for (ConfigurationObject o : this.vertices) {
            if (o.getId() == null || o.getType() != type || o.getId() == null || !o.getId().equals(Id)) continue;
            return o;
        }
        return null;
    }

    public boolean hasDependents(ConfigurationObject o) {
        for (DirectedEdge e : this.edges) {
            if (e.getStart() != o) continue;
            return true;
        }
        return false;
    }

    public boolean hasActiveDependents(ConfigurationObject o) {
        for (DirectedEdge e : this.edges) {
            if (e.getStart() != o || e.getEnd().getType() == 6) continue;
            return true;
        }
        return false;
    }

    public ConfigurationObject[] getDependents(ConfigurationObject o) {
        ArrayList<ConfigurationObject> dependents = new ArrayList<ConfigurationObject>();
        for (DirectedEdge e : this.edges) {
            if (e.getStart() != o) continue;
            dependents.add(e.getEnd());
        }
        if (dependents.size() > 0) {
            return dependents.toArray(new ConfigurationObject[dependents.size()]);
        }
        return null;
    }

    public void resolveObject(ConfigurationObject o, int type) {
        o.setType(type);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Configuration object resolved: key : " + o.getId() + ", type : " + o.getTypeName()));
        }
    }

    public void removeDependencies(ConfigurationObject o) {
        ArrayList<DirectedEdge> dependencies = new ArrayList<DirectedEdge>();
        for (DirectedEdge e : this.edges) {
            if (e.getEnd() != o) continue;
            dependencies.add(e);
        }
        for (DirectedEdge e : dependencies) {
            this.edges.remove(e);
        }
    }
}

