/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.dependency.mgt.resolvers;

import java.util.List;
import org.apache.synapse.Mediator;
import org.apache.synapse.endpoints.IndirectEndpoint;
import org.apache.synapse.mediators.ListMediator;
import org.apache.synapse.mediators.eip.Target;
import org.wso2.carbon.mediation.dependency.mgt.ConfigurationObject;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolver;
import org.wso2.carbon.mediation.dependency.mgt.DependencyResolverFactory;

public abstract class AbstractDependencyResolver
implements DependencyResolver {
    @Override
    public abstract List<ConfigurationObject> resolve(Mediator var1);

    protected void addProvider(ConfigurationObject o, List<ConfigurationObject> providers) {
        for (ConfigurationObject provider : providers) {
            if (!provider.equals(o)) continue;
            return;
        }
        providers.add(o);
    }

    protected void resolveListMediator(ListMediator listMediator, List<ConfigurationObject> providers) {
        List children = listMediator.getList();
        DependencyResolverFactory resolverFactory = DependencyResolverFactory.getInstance();
        for (Mediator child : children) {
            List<ConfigurationObject> childDependencies;
            DependencyResolver resolver = resolverFactory.getResolver(child);
            if (resolver == null || (childDependencies = resolver.resolve(child)) == null) continue;
            for (ConfigurationObject o : childDependencies) {
                this.addProvider(o, providers);
            }
        }
    }

    protected void resolveTarget(Target target, List<ConfigurationObject> providers) {
        if (target.getEndpointRef() != null) {
            this.addProvider(new ConfigurationObject(0, target.getEndpointRef()), providers);
        }
        if (target.getSequenceRef() != null) {
            this.addProvider(new ConfigurationObject(1, target.getSequenceRef()), providers);
        }
        if (target.getEndpoint() != null && target.getEndpoint() instanceof IndirectEndpoint) {
            IndirectEndpoint indirectEndpoint = (IndirectEndpoint)target.getEndpoint();
            this.addProvider(new ConfigurationObject(0, indirectEndpoint.getKey()), providers);
        }
        if (target.getSequence() != null) {
            DependencyResolver resolver = DependencyResolverFactory.getInstance().getResolver((Mediator)target.getSequence());
            List<ConfigurationObject> sequenceProviders = resolver.resolve((Mediator)target.getSequence());
            for (ConfigurationObject o : sequenceProviders) {
                this.addProvider(o, providers);
            }
        }
    }
}

