/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Startup;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.StartupFinder;
import org.apache.synapse.startup.AbstractStartup;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.StartupRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class StartupStore
extends AbstractStore<Startup> {
    public StartupStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new StartupRegistryStore(registry, configName);
        }
    }

    @Override
    protected String getFileName(Startup startup) {
        if (startup instanceof AbstractStartup) {
            return startup.getFileName();
        }
        return null;
    }

    @Override
    protected Startup getObjectToPersist(String name, SynapseConfiguration config) {
        return config.getStartup(name);
    }

    @Override
    protected OMElement saveToFile(Startup startup, SynapseConfiguration synapseConfiguration) {
        try {
            this.serializer.serializeTask(startup, synapseConfiguration, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the task: " + startup.getName() + " to the file system", e);
        }
        return null;
    }

    @Override
    protected OMElement serialize(Startup startup) {
        return StartupFinder.getInstance().serializeStartup(null, startup);
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File tasksDir = new File(this.configPath, "tasks");
        if (!tasksDir.exists()) {
            return;
        }
        File taskFile = new File(tasksDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(taskFile.getAbsolutePath());
        taskFile.delete();
    }
}

