/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediation.initializer.persistence.ServiceBusPersistenceException;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public abstract class AbstractRegistryStore {
    protected Log log = LogFactory.getLog(AbstractRegistryStore.class);
    protected UserRegistry registry;
    protected String configName;

    protected AbstractRegistryStore(UserRegistry registry, String configName) {
        this.registry = registry;
        this.configName = configName;
    }

    public abstract Collection<OMElement> getElements();

    public abstract OMElement getElement(String var1);

    public abstract void persistElement(String var1, OMElement var2, String var3);

    public abstract void deleteElement(String var1);

    protected void createCollection(String path) {
        try {
            if (!this.registry.resourceExists(path)) {
                org.wso2.carbon.registry.core.Collection collection = this.registry.newCollection();
                this.registry.put(path, (Resource)collection);
            }
        }
        catch (RegistryException e) {
            this.handleException("Unable to create the collection : " + path, (Exception)((Object)e));
        }
    }

    protected void persistElement(OMElement element, String resourcePath, String fileName) throws RegistryException {
        try {
            this.registry.beginTransaction();
            if (this.registry.resourceExists(resourcePath)) {
                this.registry.delete(resourcePath);
            }
            Resource resource = this.registry.newResource();
            resource.setContent((Object)element.toString());
            if (fileName != null) {
                resource.setProperty("DEF_FILE_NAME", fileName);
            }
            resource.setMediaType("text/xml");
            this.registry.put(resourcePath, resource);
            this.registry.commitTransaction();
        }
        catch (Exception e) {
            this.registry.rollbackTransaction();
            throw new RegistryException("Unable to persist element", (Throwable)e);
        }
    }

    protected void handleException(String message, Exception e) {
        this.log.error((Object)message, (Throwable)e);
        throw new ServiceBusPersistenceException(message, e);
    }

    protected void handleException(String message) {
        this.log.error((Object)message);
        throw new ServiceBusPersistenceException(message);
    }

    protected Collection<OMElement> getChildElementsInPath(String path) throws RegistryException {
        ArrayList<OMElement> childElements = new ArrayList<OMElement>();
        if (this.registry.resourceExists(path)) {
            Resource resource = this.registry.get(path);
            if (resource instanceof org.wso2.carbon.registry.core.Collection) {
                String[] children;
                org.wso2.carbon.registry.core.Collection collection = (org.wso2.carbon.registry.core.Collection)resource;
                for (String resourcePath : children = collection.getChildren()) {
                    OMElement resourceElem = this.getResourceAsElement(resourcePath);
                    if (resourceElem == null) continue;
                    childElements.add(resourceElem);
                }
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Collection at path " + path + " doesn't exists in the registry"));
        }
        return childElements;
    }

    protected OMElement getResourceAsElement(String resourcePath) throws RegistryException {
        OMElement resourceElem = null;
        Resource childResource = this.registry.get(resourcePath);
        try {
            resourceElem = new StAXOMBuilder(childResource.getContentStream()).getDocumentElement();
            resourceElem.build();
            String fileNameProperty = childResource.getProperty("DEF_FILE_NAME");
            if (fileNameProperty != null) {
                resourceElem.addAttribute("DEF_FILE_NAME", fileNameProperty, resourceElem.getOMFactory().createOMNamespace("", ""));
            }
        }
        catch (XMLStreamException e) {
            this.log.warn((Object)("Resource loadded from the registry with path : " + resourcePath + " is not well formed XML"));
        }
        return resourceElem;
    }

    protected String getConfigurationRoot() {
        return "/repository/synapse/" + this.configName;
    }

    protected abstract String getConfigurationPath();
}

