/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence;

import java.io.File;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.commons.executors.PriorityExecutor;
import org.apache.synapse.commons.executors.config.PriorityExecutorSerializer;
import org.apache.synapse.config.SynapseConfiguration;
import org.wso2.carbon.mediation.initializer.persistence.AbstractStore;
import org.wso2.carbon.mediation.initializer.persistence.registry.ExecutorRegistryStore;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class ExecutorStore
extends AbstractStore<PriorityExecutor> {
    public ExecutorStore(String configPath, UserRegistry registry, String configName) {
        super(configPath);
        if (registry != null) {
            this.registryStore = new ExecutorRegistryStore(registry, configName);
        }
    }

    @Override
    protected OMElement saveToFile(PriorityExecutor executor, SynapseConfiguration synapseConfig) {
        try {
            return this.serializer.serializeExecutor(executor, synapseConfig, null);
        }
        catch (Exception e) {
            this.handleException("Error while saving the executor: " + executor.getName() + " to the file system", e);
            return null;
        }
    }

    @Override
    protected void deleteFile(String fileName, SynapseConfiguration synapseConfiguration) {
        File executorsDir = new File(this.configPath, "priority-executors");
        if (!executorsDir.exists()) {
            return;
        }
        File executorFile = new File(executorsDir, fileName);
        synapseConfiguration.getArtifactDeploymentStore().addBackedUpArtifact(executorFile.getAbsolutePath());
        executorFile.delete();
    }

    @Override
    protected PriorityExecutor getObjectToPersist(String name, SynapseConfiguration config) {
        return (PriorityExecutor)config.getPriorityExecutors().get(name);
    }

    @Override
    protected String getFileName(PriorityExecutor executor) {
        return executor.getFileName();
    }

    @Override
    protected OMElement serialize(PriorityExecutor executor) {
        return PriorityExecutorSerializer.serialize(null, (PriorityExecutor)executor, (String)"http://ws.apache.org/ns/synapse");
    }
}

