/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class APIRegistryStore
extends AbstractRegistryStore {
    public APIRegistryStore(UserRegistry registry, String configName) {
        super(registry, configName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        ArrayList<OMElement> apiElements = new ArrayList();
        try {
            apiElements = this.getChildElementsInPath(this.getConfigurationPath());
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the list of APIs from the registry in path : " + this.getConfigurationPath(), (Exception)((Object)e));
        }
        return apiElements;
    }

    @Override
    public OMElement getElement(String name) {
        return null;
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (element.getLocalName().equals(XMLConfigConstants.API_ELT.getLocalPart())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Persisting API: " + name + " to the registry"));
            }
            String apiPath = this.getConfigurationPath() + "/" + name;
            try {
                this.persistElement(element, apiPath, fileName);
            }
            catch (RegistryException e) {
                this.handleException("Unable to persist the API in the path : " + apiPath, (Exception)((Object)e));
            }
        } else {
            this.handleException("The element provided to persist is not an API");
        }
    }

    @Override
    public void deleteElement(String name) {
        String apiPath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(apiPath)) {
                this.registry.delete(apiPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the API at path : " + apiPath, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "api";
    }
}

