/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.initializer.persistence.registry;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.config.xml.XMLConfigConstants;
import org.wso2.carbon.application.deployer.AppDeployerUtils;
import org.wso2.carbon.mediation.initializer.persistence.registry.AbstractRegistryStore;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.session.UserRegistry;

public class MessageProcessorRegistryStore
extends AbstractRegistryStore {
    public MessageProcessorRegistryStore(UserRegistry registry, String configName) {
        super(registry, configName);
        this.createCollection(this.getConfigurationPath());
    }

    @Override
    public Collection<OMElement> getElements() {
        ArrayList<OMElement> messageProcessorElements = new ArrayList();
        try {
            messageProcessorElements = this.getChildElementsInPath(this.getConfigurationPath());
        }
        catch (RegistryException e) {
            this.handleException("Couldn't get the list of Message Processors from the registry in path : " + this.getConfigurationPath(), (Exception)((Object)e));
        }
        return messageProcessorElements;
    }

    @Override
    public OMElement getElement(String name) {
        return null;
    }

    @Override
    public void persistElement(String name, OMElement element, String fileName) {
        if (element.getLocalName().equals(XMLConfigConstants.MESSAGE_PROCESSOR_ELT.getLocalPart())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Persisting Message Processor : " + name + " to the registry"));
            }
            String messageProcessorPath = this.getConfigurationPath() + "/" + name;
            AppDeployerUtils.attachArtifactToOwnerApp((String)fileName, (String)"synapse/message-processors", (String)name, (int)this.registry.getTenantId());
            try {
                this.persistElement(element, messageProcessorPath, fileName);
            }
            catch (RegistryException e) {
                this.handleException("Unable to persist the Message processor  in the path : " + messageProcessorPath, (Exception)((Object)e));
            }
        } else {
            this.handleException("The element provided to persist is not a Message Processor");
        }
    }

    @Override
    public void deleteElement(String name) {
        String messageProcessorPath = this.getConfigurationPath() + "/" + name;
        try {
            if (this.registry.resourceExists(messageProcessorPath)) {
                this.registry.delete(messageProcessorPath);
            }
        }
        catch (RegistryException e) {
            this.handleException("Error in deleting the Message Processor at path : " + messageProcessorPath, (Exception)((Object)e));
        }
    }

    @Override
    protected String getConfigurationPath() {
        return this.getConfigurationRoot() + "/" + "synapse-message-processors";
    }
}

