/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.ntask;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.startup.tasks.MessageInjector;
import org.apache.synapse.task.Task;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.ntask.NTaskTaskManager;
import org.wso2.carbon.mediation.ntask.internal.NtaskService;
import org.wso2.carbon.ntask.core.AbstractTask;
import org.wso2.carbon.utils.CarbonUtils;

public class NTaskAdapter
extends AbstractTask {
    private static final Log logger = LogFactory.getLog((String)NTaskAdapter.class.getName());
    private static final Map<String, Object> synapseTaskProperties = new HashMap<String, Object>();
    private static final Object lock = new Object();
    private boolean initialized = false;
    private Task synapseTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean addProperty(String name, Object property) {
        if (name == null) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            return synapseTaskProperties.put(NTaskTaskManager.tenantId() + name, property) == property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeProperty(String name) {
        if (name == null) {
            return false;
        }
        Object object = lock;
        synchronized (object) {
            return synapseTaskProperties.remove(NTaskTaskManager.tenantId() + name) == null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object taskInstance;
        Map properties = this.getProperties();
        if (properties == null) {
            return;
        }
        String taskName = (String)properties.get("task.name");
        if (taskName == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            taskInstance = synapseTaskProperties.get(NTaskTaskManager.tenantId() + taskName);
        }
        if (taskInstance == null) {
            this.checkLoadTenant((String)properties.get("__TENANT_ID_PROP__"));
            return;
        }
        if (!(taskInstance instanceof Task)) {
            return;
        }
        if (taskInstance instanceof MessageInjector) {
            MessageInjector messageInjectorTask = (MessageInjector)taskInstance;
            messageInjectorTask.addRuntimeProperty("CURRENT_TASK_EXECUTING_TENANT_IDENTIFIER", (Object)PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId());
        }
        this.synapseTask = (Task)taskInstance;
        this.initialized = true;
    }

    public void execute() {
        if (!this.isInitialized()) {
            return;
        }
        if (this.getProperties().get("task.count") == null || this.getProperties().get("task.count") != null && Integer.parseInt((String)this.getProperties().get("task.count")) == 0) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("#execute Executing NTaskAdapter: " + this.getProperties() + " Worker-node[" + CarbonUtils.isWorkerNode() + "]"));
        }
        Map properties = this.getProperties();
        this.checkLoadTenant((String)properties.get("__TENANT_ID_PROP__"));
        this.synapseTask.execute();
    }

    private void checkLoadTenant(String sTenantId) {
        Integer iTenantId;
        if (sTenantId != null && !(iTenantId = Integer.valueOf(Integer.parseInt(sTenantId))).equals(-1234)) {
            NtaskService.loadTenant(iTenantId);
        }
    }

    private boolean isInitialized() {
        return this.initialized;
    }
}

