/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.ntask;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.synapse.task.Task;
import org.apache.synapse.task.TaskDescription;
import org.wso2.carbon.mediation.ntask.NTaskAdapter;
import org.wso2.carbon.ntask.core.TaskInfo;

final class TaskBuilder {
    public static final String REMOTE_TASK_NAME = "__REMOTE_TASK_NAME__";

    TaskBuilder() {
    }

    public static TaskInfo buildTaskInfo(TaskDescription taskDescription, Map<String, Object> properties) throws Exception {
        return TaskBuilder.buildTaskInfo(taskDescription, false, properties);
    }

    public static TaskInfo buildTaskInfo(TaskDescription description, boolean system, Map<String, Object> tmProperties) throws Exception {
        Object o2;
        TaskInfo.TriggerInfo triggerInfo = new TaskInfo.TriggerInfo();
        String cron = description.getCronExpression();
        if (cron != null && cron.trim().length() == 0) {
            cron = null;
        }
        triggerInfo.setCronExpression(cron);
        if (description.getStartTime() != null) {
            triggerInfo.setStartTime(description.getStartTime().getTime());
        } else if (triggerInfo.getCronExpression() == null) {
            // empty if block
        }
        if (description.getEndTime() != null) {
            triggerInfo.setEndTime(description.getEndTime().getTime());
        }
        if (cron == null && !system && description.getInterval() < 1000L) {
            throw new Exception("Task interval cannot be less than 1 second for user tasks");
        }
        triggerInfo.setIntervalMillis(description.getInterval());
        triggerInfo.setRepeatCount(description.getCount() > 0 ? description.getCount() - 1 : description.getCount());
        triggerInfo.setDisallowConcurrentExecution(true);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(REMOTE_TASK_NAME, description.getName());
        Map properties = description.getProperties();
        for (Object o2 : properties.keySet()) {
            if (o2 == null) continue;
            props.put((String)o2, (String)properties.get(o2));
        }
        if (tmProperties != null) {
            o2 = tmProperties.keySet().iterator();
            while (o2.hasNext()) {
                String name = (String)o2.next();
                if (!(tmProperties.get(name) instanceof String)) continue;
                props.put(name, (String)tmProperties.get(name));
            }
        }
        if (!((o2 = description.getResource("ClassName")) instanceof String)) {
            return null;
        }
        String taskClassName = (String)o2;
        props.put("ClassName", taskClassName);
        String nameGroup = description.getName() + "::" + description.getTaskGroup();
        props.put("task.name", nameGroup);
        props.put("task.count", String.valueOf(description.getCount()));
        Object taskInstance = description.getResource("Instance");
        if (taskInstance instanceof Task) {
            NTaskAdapter.addProperty(nameGroup, taskInstance);
        }
        return new TaskInfo(description.getName(), NTaskAdapter.class.getName(), props, triggerInfo);
    }

    public static TaskDescription buildTaskDescription(TaskInfo taskInfo) {
        TaskDescription taskDescription = new TaskDescription();
        taskDescription.setName(taskInfo.getName());
        Map taskProps = taskInfo.getProperties();
        TaskInfo.TriggerInfo triggerInfo = taskInfo.getTriggerInfo();
        taskDescription.setCronExpression(triggerInfo.getCronExpression());
        taskDescription.setStartTime(TaskBuilder.dateToCal(triggerInfo.getStartTime()));
        taskDescription.setEndTime(TaskBuilder.dateToCal(triggerInfo.getEndTime()));
        taskDescription.setCount(triggerInfo.getRepeatCount() + 1);
        taskDescription.setInterval(triggerInfo.getIntervalMillis());
        taskDescription.setIntervalInMs(true);
        return taskDescription;
    }

    private static Calendar dateToCal(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }
}

