/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediation.security.vault.ui;

import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.owasp.encoder.Encode;
import org.wso2.carbon.mediation.security.stub.MediationSecurityAdminServiceStub;
import org.wso2.carbon.mediation.security.vault.cipher.tool.CipherTool;
import org.wso2.carbon.mediation.security.vault.ui.Utils;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.properties.stub.PropertiesAdminServiceStub;
import org.wso2.carbon.registry.properties.stub.beans.xsd.PropertiesBean;
import org.wso2.carbon.registry.properties.stub.beans.xsd.RetentionBean;
import org.wso2.carbon.registry.properties.stub.utils.xsd.Property;
import org.wso2.carbon.ui.CarbonUIUtil;

public class PropertiesServiceClient {
    private static final Log log = LogFactory.getLog(PropertiesServiceClient.class);
    private PropertiesAdminServiceStub propertAdminServicestub;
    private MediationSecurityAdminServiceStub securityAdminServiceStub;
    private HttpSession session;
    private CipherTool cipherTool;

    public PropertiesServiceClient(ServletConfig config, HttpSession session) throws RegistryException {
        this.session = session;
        String cookie = (String)session.getAttribute("wso2carbon.admin.service.cookie");
        String backendServerURL = CarbonUIUtil.getServerURL((ServletContext)config.getServletContext(), (HttpSession)this.session);
        ConfigurationContext configContext = (ConfigurationContext)config.getServletContext().getAttribute("ConfigurationContext");
        String propertyEPR = backendServerURL + "PropertiesAdminService";
        String mediationSecurityEPR = backendServerURL + "MediationSecurityAdminService";
        try {
            this.propertAdminServicestub = new PropertiesAdminServiceStub(configContext, propertyEPR);
            ServiceClient client = this.propertAdminServicestub._getServiceClient();
            Options option = client.getOptions();
            option.setManageSession(true);
            option.setProperty("Cookie", (Object)cookie);
            this.securityAdminServiceStub = new MediationSecurityAdminServiceStub(configContext, mediationSecurityEPR);
            ServiceClient securityclient = this.securityAdminServiceStub._getServiceClient();
            Options securityoption = securityclient.getOptions();
            securityoption.setManageSession(true);
            securityoption.setProperty("Cookie", (Object)cookie);
            this.cipherTool = new CipherTool(this.securityAdminServiceStub);
        }
        catch (AxisFault axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
    }

    public int getPropertiesLenght() throws RegistryException {
        String path = "/_system/config/repository/components/secure-vault";
        PropertiesBean bean = null;
        try {
            bean = this.propertAdminServicestub.getProperties(path, "no");
        }
        catch (Exception axisFault) {
            String msg = "Failed to initiate resource service client. " + axisFault.getMessage();
            log.error((Object)msg, (Throwable)axisFault);
            throw new RegistryException(msg, (Throwable)axisFault);
        }
        return bean.getSysProperties().length;
    }

    public PropertiesBean getProperties(HttpServletRequest request, int pageNumber) throws Exception {
        String path = "/_system/config/repository/components/secure-vault";
        Boolean view = (Boolean)request.getSession().getAttribute("show.system-properties");
        String viewProps = view != null ? (view.booleanValue() ? "yes" : "no") : "no";
        PropertiesBean bean = null;
        bean = this.propertAdminServicestub.getProperties(path, viewProps);
        int itemPerPage = 15;
        int start = pageNumber * itemPerPage;
        if (start >= 0 && bean.getSysProperties() != null && bean.getSysProperties().length > 0) {
            int length;
            int n = length = start > 0 ? bean.getSysProperties().length - start : bean.getSysProperties().length;
            if (length > itemPerPage) {
                length = itemPerPage;
            }
            String[] prams = new String[length > 0 ? length : 1];
            for (int i = 0; i <= itemPerPage - 1; ++i) {
                if (i >= prams.length) continue;
                prams[i] = bean.getSysProperties()[i + start];
            }
            bean.setSysProperties(prams);
        }
        if (bean == null) {
            return null;
        }
        if (bean.getLifecycleProperties() == null) {
            bean.setLifecycleProperties(new String[0]);
        }
        if (bean.getSysProperties() == null) {
            bean.setSysProperties(new String[0]);
        }
        if (bean.getValidationProperties() == null) {
            bean.setValidationProperties(new String[0]);
        }
        if (bean.getProperties() == null) {
            bean.setProperties(new Property[0]);
        }
        return bean;
    }

    public void setProperty(HttpServletRequest request) throws Exception {
        String path = "/_system/config/repository/components/secure-vault";
        String name = (String)Utils.getParameter(request, "name");
        String value = (String)Utils.getParameter(request, "value");
        this.validateInput(name, value);
        String encrypted = this.cipherTool.doEncryption(value);
        try {
            this.propertAdminServicestub.setProperty(path, name, encrypted);
        }
        catch (Exception e) {
            String msg = "Failed to add the property. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
    }

    public void updateProperty(HttpServletRequest request) throws Exception {
        String path = "/_system/config/repository/components/secure-vault";
        String name = (String)Utils.getParameter(request, "name");
        String value = (String)Utils.getParameter(request, "value");
        String oldName = (String)Utils.getParameter(request, "oldName");
        this.validateInput(name, value);
        String encrypted = this.cipherTool.doEncryption(value);
        try {
            this.propertAdminServicestub.updateProperty(path, name, encrypted, oldName);
        }
        catch (Exception e) {
            String msg = "Failed to update the property. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(e);
        }
    }

    public void removeProperty(HttpServletRequest request) throws Exception {
        String path = (String)Utils.getParameter(request, "path");
        String name = (String)Utils.getParameter(request, "name");
        try {
            this.propertAdminServicestub.removeProperty(path, name);
        }
        catch (Exception e) {
            String msg = "Failed to remove the property. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new Exception(e);
        }
    }

    public boolean setRetentionProperties(HttpServletRequest request) throws Exception {
        try {
            RetentionBean bean;
            String path = request.getParameter("path");
            String fromDate = request.getParameter("fromDate");
            if (fromDate == null || "".equals(fromDate)) {
                bean = null;
            } else {
                bean = new RetentionBean();
                bean.setFromDate(fromDate);
                bean.setToDate(request.getParameter("toDate"));
                String lockedOperationsParam = request.getParameter("lockedOperations");
                bean.setWriteLocked(lockedOperationsParam.contains("write"));
                bean.setDeleteLocked(lockedOperationsParam.contains("delete"));
            }
            this.propertAdminServicestub.setRetentionProperties(path, bean);
        }
        catch (Exception e) {
            log.error((Object)("Failed to add retention: " + e.getMessage()), (Throwable)e);
            throw new Exception(e);
        }
        return true;
    }

    public RetentionBean getRetentionProperties(HttpServletRequest request) throws RegistryException {
        try {
            return this.propertAdminServicestub.getRetentionProperties(request.getParameter("path"));
        }
        catch (Exception e) {
            String msg = "Could not retrieve retention details " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    private void validateInput(String name, String value) throws Exception {
        String regEx = System.getProperty("org.wso2.SecureVaultPasswordRegEx");
        if (regEx == null || regEx.isEmpty()) {
            regEx = "^[\\S]{5,30}$";
        }
        if (!value.matches(regEx)) {
            String message = "Password value for " + name + " does not match with the configured regular expression.";
            message = Encode.forJavaScript((String)message);
            log.error((Object)message);
            throw new Exception(message);
        }
    }
}

