/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.aggregate;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.drop.DropMediator;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.ListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class AggregateMediator
extends AbstractListMediator {
    public static final String AGGREGATE_ELEMENT_TYPE_ROOT = "root";
    public static final String AGGREGATE_ELEMENT_TYPE_CHILD = "child";
    protected static final QName CORELATE_ON_Q = new QName("http://ws.apache.org/ns/synapse", "correlateOn");
    protected static final QName COMPLETE_CONDITION_Q = new QName("http://ws.apache.org/ns/synapse", "completeCondition");
    protected static final QName MESSAGE_COUNT_Q = new QName("http://ws.apache.org/ns/synapse", "messageCount");
    protected static final QName ON_COMPLETE_Q = new QName("http://ws.apache.org/ns/synapse", "onComplete");
    private static final QName EXPRESSION_Q = new QName("", "expression");
    private static final QName TIMEOUT_Q = new QName("", "timeout");
    private static final QName MIN_Q = new QName("", "min");
    private static final QName MAX_Q = new QName("", "max");
    private static final QName SEQUENCE_Q = new QName("", "sequence");
    private static final QName ID_Q = new QName("id");
    protected static final QName AGGREGATE_ELEMENT_TYPE_Q = new QName("", "aggregateElementType");
    private static final QName ENCLOSING_ELEMENT_PROPERTY = new QName("", "enclosingElementProperty");
    private long completionTimeoutSec = 0L;
    private Value minMessagesToComplete;
    private Value maxMessagesToComplete;
    private SynapsePath correlateExpression = null;
    private SynapsePath aggregationExpression = null;
    private String onCompleteSequenceRef = null;
    private String id;
    private String aggregateElementType = null;
    private String enclosingElementPropertyName = null;

    public String getAggregateElementType() {
        return this.aggregateElementType;
    }

    public void setAggregateElementType(String aggregateElementType) {
        this.aggregateElementType = aggregateElementType;
    }

    public String getEnclosingElementPropertyName() {
        return this.enclosingElementPropertyName;
    }

    public void setEnclosingElementPropertyName(String enclosingElementPropertyName) {
        this.enclosingElementPropertyName = enclosingElementPropertyName;
    }

    public long getCompletionTimeoutSec() {
        return this.completionTimeoutSec;
    }

    public Value getMinMessagesToComplete() {
        return this.minMessagesToComplete;
    }

    public void setMinMessagesToComplete(Value minMessagesToComplete) {
        this.minMessagesToComplete = minMessagesToComplete;
    }

    public Value getMaxMessagesToComplete() {
        return this.maxMessagesToComplete;
    }

    public void setMaxMessagesToComplete(Value maxMessagesToComplete) {
        this.maxMessagesToComplete = maxMessagesToComplete;
    }

    public void setCompletionTimeoutSec(long completionTimeoutSec) {
        this.completionTimeoutSec = completionTimeoutSec;
    }

    public SynapsePath getCorrelateExpression() {
        return this.correlateExpression;
    }

    public void setCorrelateExpression(SynapsePath correlateExpression) {
        this.correlateExpression = correlateExpression;
    }

    public SynapsePath getAggregationExpression() {
        return this.aggregationExpression;
    }

    public void setAggregationExpression(SynapsePath aggregationExpression) {
        this.aggregationExpression = aggregationExpression;
    }

    public String getOnCompleteSequenceRef() {
        return this.onCompleteSequenceRef;
    }

    public void setOnCompleteSequenceRef(String onCompleteSequenceRef) {
        this.onCompleteSequenceRef = onCompleteSequenceRef;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTagLocalName() {
        return "aggregate";
    }

    public OMElement serialize(OMElement parent) {
        OMElement aggregator = fac.createOMElement("aggregate", synNS);
        AggregateMediator.saveTracingState((OMElement)aggregator, (Mediator)this);
        if (this.correlateExpression != null) {
            OMElement corelateOn = fac.createOMElement("correlateOn", synNS);
            SynapsePathSerializer.serializePath((SynapsePath)this.correlateExpression, (OMElement)corelateOn, (String)"expression");
            aggregator.addChild((OMNode)corelateOn);
        }
        OMElement completeCond = fac.createOMElement("completeCondition", synNS);
        if (this.completionTimeoutSec != 0L) {
            completeCond.addAttribute("timeout", Long.toString(this.completionTimeoutSec), nullNS);
        }
        OMElement messageCount = fac.createOMElement("messageCount", synNS);
        if (this.minMessagesToComplete != null) {
            OMElement min = fac.createOMElement("min", synNS);
            new ValueSerializer().serializeValue(this.minMessagesToComplete, "min", messageCount);
        }
        if (this.maxMessagesToComplete != null) {
            OMElement max = fac.createOMElement("min", synNS);
            new ValueSerializer().serializeValue(this.maxMessagesToComplete, "max", messageCount);
        }
        completeCond.addChild((OMNode)messageCount);
        aggregator.addChild((OMNode)completeCond);
        OMElement onCompleteElem = fac.createOMElement("onComplete", synNS);
        if (this.aggregateElementType != null) {
            onCompleteElem.addAttribute("aggregateElementType", this.aggregateElementType, nullNS);
        }
        if (this.aggregationExpression != null) {
            SynapsePathSerializer.serializePath((SynapsePath)this.aggregationExpression, (OMElement)onCompleteElem, (String)"expression");
        }
        if (this.onCompleteSequenceRef != null) {
            onCompleteElem.addAttribute("sequence", this.onCompleteSequenceRef, nullNS);
        } else if (this.getList().size() > 0) {
            this.serializeChildren(onCompleteElem, this.getList());
        }
        if (this.enclosingElementPropertyName != null) {
            onCompleteElem.addAttribute("enclosingElementProperty", this.enclosingElementPropertyName, nullNS);
        }
        aggregator.addChild((OMNode)onCompleteElem);
        if (this.id != null) {
            aggregator.addAttribute("id", this.id, nullNS);
        }
        if (parent != null) {
            parent.addChild((OMNode)aggregator);
        }
        return aggregator;
    }

    public void build(OMElement elem) {
        OMElement onComplete;
        OMElement completeCond;
        OMAttribute corelateExpr;
        OMElement corelateOn = elem.getFirstChildWithName(CORELATE_ON_Q);
        OMAttribute idAttr = elem.getAttribute(ID_Q);
        ValueFactory valueFactory = new ValueFactory();
        if (idAttr != null) {
            this.id = idAttr.getAttributeValue();
        }
        if (corelateOn != null && (corelateExpr = corelateOn.getAttribute(EXPRESSION_Q)) != null) {
            try {
                this.correlateExpression = SynapsePathFactory.getSynapsePath((OMElement)corelateOn, (QName)EXPRESSION_Q);
            }
            catch (JaxenException e) {
                throw new MediatorException("Unable to load the corelate XPATH expression");
            }
        }
        if ((completeCond = elem.getFirstChildWithName(COMPLETE_CONDITION_Q)) != null) {
            OMElement messageCount;
            OMAttribute completeTimeout = completeCond.getAttribute(TIMEOUT_Q);
            if (completeTimeout != null) {
                this.completionTimeoutSec = Long.parseLong(completeTimeout.getAttributeValue());
            }
            if ((messageCount = completeCond.getFirstChildWithName(MESSAGE_COUNT_Q)) != null) {
                OMAttribute maxExpr;
                OMAttribute minExpr = messageCount.getAttribute(MIN_Q);
                if (minExpr != null) {
                    try {
                        Value min;
                        this.minMessagesToComplete = min = valueFactory.createValue("min", messageCount);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new MediatorException("Unable to load the corelate XPATH expression");
                    }
                }
                if ((maxExpr = messageCount.getAttribute(MAX_Q)) != null) {
                    try {
                        Value max;
                        this.maxMessagesToComplete = max = valueFactory.createValue("max", messageCount);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new MediatorException("Unable to load the corelate XPATH expression");
                    }
                }
            }
        }
        if ((onComplete = elem.getFirstChildWithName(ON_COMPLETE_Q)) != null) {
            OMAttribute onCompleteSequence;
            OMAttribute enclosingElementPropertyName;
            OMAttribute aggregateExpr;
            OMAttribute aggregateElementTypeAttr = onComplete.getAttribute(AGGREGATE_ELEMENT_TYPE_Q);
            if (aggregateElementTypeAttr != null) {
                String elementType = aggregateElementTypeAttr.getAttributeValue();
                this.aggregateElementType = elementType.equals(AGGREGATE_ELEMENT_TYPE_ROOT) || elementType.equals(AGGREGATE_ELEMENT_TYPE_CHILD) ? elementType : AGGREGATE_ELEMENT_TYPE_ROOT;
            }
            if ((aggregateExpr = onComplete.getAttribute(EXPRESSION_Q)) != null) {
                try {
                    this.aggregationExpression = SynapsePathFactory.getSynapsePath((OMElement)onComplete, (QName)EXPRESSION_Q);
                }
                catch (JaxenException e) {
                    throw new MediatorException("Unable to load the aggregating XPATH");
                }
            }
            if ((enclosingElementPropertyName = onComplete.getAttribute(ENCLOSING_ELEMENT_PROPERTY)) != null) {
                this.enclosingElementPropertyName = enclosingElementPropertyName.getAttributeValue();
            }
            if ((onCompleteSequence = onComplete.getAttribute(SEQUENCE_Q)) != null) {
                this.onCompleteSequenceRef = onCompleteSequence.getAttributeValue();
            } else if (onComplete.getFirstElement() != null) {
                this.addChildren(onComplete, (ListMediator)this);
            } else {
                this.addChild((Mediator)new DropMediator());
            }
        }
    }
}

