/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.commons.json.JsonUtil;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.continuation.ContinuationStackManager;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.core.axis2.Axis2Sender;
import org.apache.synapse.debug.constructs.EnclosedInlinedSequence;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.base.SequenceMediator;
import org.apache.synapse.util.FixedByteArrayOutputStream;
import org.apache.synapse.util.MessageHelper;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediator.cache.CachableResponse;
import org.wso2.carbon.mediator.cache.CacheManager;
import org.wso2.carbon.mediator.cache.CachingConstants;
import org.wso2.carbon.mediator.cache.CachingException;
import org.wso2.carbon.mediator.cache.MediatorCacheInvalidator;
import org.wso2.carbon.mediator.cache.digest.DigestGenerator;
import org.wso2.carbon.mediator.cache.util.HttpCachingFilter;

public class CacheMediator
extends AbstractMediator
implements ManagedLifecycle,
EnclosedInlinedSequence {
    private final String jsonContentType = "application/json";
    private String id;
    private long timeout = 5000L;
    private boolean collector = false;
    private SequenceMediator onCacheHitSequence = null;
    private String onCacheHitRef = null;
    private String[] headersToExcludeInHash = new String[]{""};
    private DigestGenerator digestGenerator = CachingConstants.DEFAULT_HASH_GENERATOR;
    private int inMemoryCacheSize = -1;
    private Pattern responseCodePattern;
    private int maxMessageSize = -1;
    private String responseCodes = ".*";
    private String protocolType = "HTTP";
    private String[] hTTPMethodsToCache = new String[]{"*"};
    private boolean cacheControlEnabled = false;
    private boolean addAgeHeaderEnabled = false;
    private static final String SC_NOT_MODIFIED = "304";
    private CacheManager cacheManager;
    private String hashGenerator = null;
    private String scope = null;
    private String implementationType = null;
    private boolean isPreviousCacheImplementation = false;

    public CacheMediator(CacheManager cacheManager) {
        this.id = UUID.randomUUID().toString();
        this.responseCodePattern = Pattern.compile(this.responseCodes);
        this.cacheManager = cacheManager;
    }

    public void init(SynapseEnvironment se) {
        if (this.onCacheHitSequence != null) {
            this.onCacheHitSequence.init(se);
        }
        this.exposeInvalidator(se.createMessageContext());
    }

    public void destroy() {
        if (this.onCacheHitSequence != null) {
            this.onCacheHitSequence.destroy();
        }
        this.cacheManager.remove(this.id);
    }

    public boolean mediate(org.apache.synapse.MessageContext synCtx) {
        ConfigurationContext cfgCtx;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Cache mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if ((cfgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext().getConfigurationContext()) == null) {
            this.handleException("Unable to perform caching,  ConfigurationContext cannot be found", synCtx);
            return false;
        }
        boolean result = true;
        try {
            if (synCtx.isResponse()) {
                this.processResponseMessage(synCtx, cfgCtx, synLog);
            } else {
                result = this.processRequestMessage(synCtx, synLog);
            }
        }
        catch (ExecutionException e) {
            synLog.traceOrDebug((Object)"Unable to get the response");
        }
        return result;
    }

    private CachableResponse cacheNewResponse(String requestHash) {
        CachableResponse response = new CachableResponse();
        response.setRequestHash(requestHash);
        response.setTimeout(this.timeout);
        return response;
    }

    private boolean processRequestMessage(org.apache.synapse.MessageContext synCtx, SynapseLog synLog) throws ExecutionException {
        if (this.collector) {
            this.handleException("Request messages cannot be handled in a collector cache", synCtx);
        }
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String requestHash = null;
        try {
            requestHash = this.digestGenerator.getDigest(((Axis2MessageContext)synCtx).getAxis2MessageContext());
            synCtx.setProperty("requestHash", (Object)requestHash);
        }
        catch (CachingException e) {
            this.handleException("Error in calculating the hash value of the request", e, synCtx);
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Generated request hash : " + requestHash));
        }
        CachableResponse cachedResponse = (CachableResponse)this.getMediatorCache().get((Object)requestHash);
        synCtx.setProperty("CachableResponse", (Object)cachedResponse);
        String httpMethod = (String)msgCtx.getProperty("HTTP_METHOD");
        cachedResponse.setHttpMethod(httpMethod);
        cachedResponse.setProtocolType(this.protocolType);
        cachedResponse.setResponseCodePattern(this.responseCodePattern);
        cachedResponse.setHTTPMethodsToCache(this.hTTPMethodsToCache);
        cachedResponse.setMaxMessageSize(this.maxMessageSize);
        cachedResponse.setCacheControlEnabled(this.cacheControlEnabled);
        cachedResponse.setAddAgeHeaderEnabled(this.addAgeHeaderEnabled);
        if (cachedResponse.getResponsePayload() != null || cachedResponse.getResponseEnvelope() != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("Cache-hit for message ID : " + synCtx.getMessageID()));
            }
            if ("HTTP".equals(this.getProtocolType()) && cachedResponse.isCacheControlEnabled() && HttpCachingFilter.isValidCacheEntry(cachedResponse, synCtx)) {
                return true;
            }
            synCtx.setResponse(true);
            this.replaceEnvelopeWithCachedResponse(synCtx, synLog, msgCtx, cachedResponse);
            return false;
        }
        return true;
    }

    private void replaceEnvelopeWithCachedResponse(org.apache.synapse.MessageContext synCtx, SynapseLog synLog, MessageContext msgCtx, CachableResponse cachedResponse) {
        Map<String, Object> headerProperties;
        try {
            if (cachedResponse.isJson()) {
                byte[] payload = cachedResponse.getResponsePayload();
                OMElement response = JsonUtil.getNewJsonPayload((MessageContext)msgCtx, (byte[])payload, (int)0, (int)payload.length, (boolean)false, (boolean)false);
                if (msgCtx.getEnvelope().getBody().getFirstElement() != null) {
                    msgCtx.getEnvelope().getBody().getFirstElement().detach();
                }
                msgCtx.getEnvelope().getBody().addChild((OMNode)response);
            } else {
                msgCtx.setEnvelope(MessageHelper.cloneSOAPEnvelope((SOAPEnvelope)cachedResponse.getResponseEnvelope()));
            }
        }
        catch (AxisFault e) {
            this.handleException("Error creating response OM from cache : " + this.id, synCtx);
        }
        if ("HTTP".equals(this.getProtocolType())) {
            if (cachedResponse.getStatusCode() != null) {
                msgCtx.setProperty("HTTP_SC", (Object)Integer.parseInt(cachedResponse.getStatusCode()));
            }
            if (cachedResponse.getStatusReason() != null) {
                msgCtx.setProperty("HTTP_SC_DESC", cachedResponse.getStatusReason());
            }
            if (cachedResponse.isAddAgeHeaderEnabled()) {
                HttpCachingFilter.setAgeHeader(cachedResponse, msgCtx);
            }
        }
        if (msgCtx.isDoingREST()) {
            msgCtx.removeProperty("NO_ENTITY_BODY");
            msgCtx.removeProperty("ContentType");
        }
        if ((headerProperties = cachedResponse.getHeaderProperties()) != null) {
            msgCtx.setProperty("TRANSPORT_HEADERS", headerProperties);
            msgCtx.setProperty("messageType", headerProperties.get("messageType"));
        }
        if (this.onCacheHitSequence != null) {
            synLog.traceOrDebug((Object)"Delegating message to the onCacheHit Anonymous sequence");
            ContinuationStackManager.addReliantContinuationState((org.apache.synapse.MessageContext)synCtx, (int)0, (int)this.getMediatorPosition());
            if (this.onCacheHitSequence.mediate(synCtx)) {
                ContinuationStackManager.removeReliantContinuationState((org.apache.synapse.MessageContext)synCtx);
            }
        } else if (this.onCacheHitRef != null) {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("Delegating message to the onCacheHit sequence : " + this.onCacheHitRef));
            }
            ContinuationStackManager.updateSeqContinuationState((org.apache.synapse.MessageContext)synCtx, (int)this.getMediatorPosition());
            synCtx.getSequence(this.onCacheHitRef).mediate(synCtx);
        } else {
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)("Request message " + synCtx.getMessageID() + " was served from the cache"));
            }
            synCtx.setTo(null);
            Axis2Sender.sendBack((org.apache.synapse.MessageContext)synCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResponseMessage(org.apache.synapse.MessageContext synCtx, ConfigurationContext cfgCtx, SynapseLog synLog) {
        if (!this.collector) {
            this.handleException("Response messages cannot be handled in a non collector cache", synCtx);
        }
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        CachableResponse response = (CachableResponse)synCtx.getProperty("CachableResponse");
        if (response != null) {
            boolean toCache = true;
            if ("HTTP".equals(response.getProtocolType())) {
                Object httpStatus = msgCtx.getProperty("HTTP_SC");
                String statusCode = null;
                if (response.isCacheControlEnabled() && HttpCachingFilter.isNoStore(msgCtx)) {
                    response.clean();
                    return;
                }
                if (httpStatus instanceof String) {
                    statusCode = ((String)httpStatus).trim();
                } else if (httpStatus != null) {
                    statusCode = String.valueOf(httpStatus);
                }
                if (statusCode != null) {
                    if (statusCode.equals(SC_NOT_MODIFIED)) {
                        this.replaceEnvelopeWithCachedResponse(synCtx, synLog, msgCtx, response);
                        return;
                    }
                    Matcher m = response.getResponseCodePattern().matcher(statusCode);
                    if (m.matches()) {
                        response.setStatusCode(statusCode);
                        response.setStatusReason((String)msgCtx.getProperty("HTTP_SC_DESC"));
                    } else {
                        toCache = false;
                    }
                }
                if (toCache) {
                    toCache = false;
                    String httpMethod = response.getHttpMethod();
                    for (String method : response.getHTTPMethodsToCache()) {
                        if (!method.equals("*") && !method.equals(httpMethod)) continue;
                        toCache = true;
                        break;
                    }
                }
            }
            if (toCache) {
                String contentType = (String)msgCtx.getProperty("ContentType");
                if (contentType != null) {
                    contentType = contentType.split(";")[0];
                }
                if (contentType != null && contentType.equals("application/json")) {
                    byte[] responsePayload = JsonUtil.jsonPayloadToByteArray((MessageContext)msgCtx);
                    if (response.getMaxMessageSize() > -1 && responsePayload.length > response.getMaxMessageSize()) {
                        synLog.traceOrDebug((Object)"Message size exceeds the upper bound for caching, request will not be cached");
                        return;
                    }
                    response.setResponsePayload(responsePayload);
                    response.setResponseEnvelope(null);
                    response.setJson(true);
                } else {
                    SOAPEnvelope clonedEnvelope = MessageHelper.cloneSOAPEnvelope((SOAPEnvelope)synCtx.getEnvelope());
                    if (response.getMaxMessageSize() > -1) {
                        FixedByteArrayOutputStream fbaos = new FixedByteArrayOutputStream(response.getMaxMessageSize());
                        try {
                            clonedEnvelope.serialize((OutputStream)fbaos);
                        }
                        catch (XMLStreamException e) {
                            this.handleException("Error in checking the message size", e, synCtx);
                        }
                        catch (SynapseException syne) {
                            synLog.traceOrDebug((Object)"Message size exceeds the upper bound for caching, request will not be cached");
                            return;
                        }
                        finally {
                            try {
                                fbaos.close();
                            }
                            catch (IOException e) {
                                this.handleException("Error occurred while closing the FixedByteArrayOutputStream ", e, synCtx);
                            }
                        }
                    }
                    response.setResponsePayload(null);
                    response.setResponseEnvelope(clonedEnvelope);
                    response.setJson(false);
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Storing the response message into the cache with ID : " + this.id + " for request hash : " + response.getRequestHash()));
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Storing the response for the message with ID : " + synCtx.getMessageID() + " with request hash ID : " + response.getRequestHash() + " in the cache"));
                }
                Map headers = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
                String messageType = (String)msgCtx.getProperty("messageType");
                ConcurrentHashMap<String, Object> headerProperties = new ConcurrentHashMap<String, Object>();
                if (response.isCacheControlEnabled() || response.isAddAgeHeaderEnabled()) {
                    try {
                        HttpCachingFilter.setResponseCachedTime(headers, response);
                    }
                    catch (ParseException e) {
                        synLog.auditWarn((Object)("Error occurred while parsing the date." + e.getMessage()));
                    }
                }
                for (Map.Entry entry : headers.entrySet()) {
                    headerProperties.put((String)entry.getKey(), entry.getValue());
                }
                headerProperties.put("messageType", messageType);
                headerProperties.put("cacheKey", response.getRequestHash());
                response.setHeaderProperties(headerProperties);
                msgCtx.setProperty("TRANSPORT_HEADERS", headerProperties);
            } else {
                response.clean();
            }
        } else {
            synLog.auditWarn((Object)"A response message without a valid mapping to the request hash found. Unable to store the response in cache");
        }
    }

    public LoadingCache<String, CachableResponse> getMediatorCache() {
        LoadingCache cache = this.cacheManager.get(this.id);
        if (cache == null) {
            cache = this.inMemoryCacheSize > -1 ? CacheBuilder.newBuilder().expireAfterWrite(this.timeout, TimeUnit.SECONDS).maximumSize((long)this.inMemoryCacheSize).build((CacheLoader)new CacheLoader<String, CachableResponse>(){

                public CachableResponse load(String requestHash) throws Exception {
                    return CacheMediator.this.cacheNewResponse(requestHash);
                }
            }) : CacheBuilder.newBuilder().expireAfterWrite(this.timeout, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, CachableResponse>(){

                public CachableResponse load(String requestHash) throws Exception {
                    return CacheMediator.this.cacheNewResponse(requestHash);
                }
            });
            this.cacheManager.put(this.id, (LoadingCache<String, CachableResponse>)cache);
        }
        return cache;
    }

    public Mediator getInlineSequence(SynapseConfiguration synCfg, int inlinedSeqIdentifier) {
        if (inlinedSeqIdentifier == 0) {
            if (this.onCacheHitSequence != null) {
                return this.onCacheHitSequence;
            }
            if (this.onCacheHitRef != null) {
                return synCfg.getSequence(this.onCacheHitRef);
            }
        }
        return null;
    }

    public void exposeInvalidator(org.apache.synapse.MessageContext msgCtx) {
        String name = "org.wso2.carbon.mediator.cache:type=Cache,tenant=" + PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
        try {
            ObjectName cacheMBeanObjName = new ObjectName(name);
            MBeanServer mserver = this.getMBeanServer();
            Set<ObjectName> set = mserver.queryNames(cacheMBeanObjName, null);
            if (set.isEmpty()) {
                MediatorCacheInvalidator cacheMBean = new MediatorCacheInvalidator(this.cacheManager, PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(), PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId(), msgCtx);
                mserver.registerMBean(cacheMBean, cacheMBeanObjName);
            }
        }
        catch (MalformedObjectNameException e) {
            this.handleException("The format of the string does not correspond to a valid ObjectName.", e, msgCtx);
        }
        catch (NotCompliantMBeanException e) {
            this.handleException("MBean with the name " + name + " is already registered.", e, msgCtx);
        }
        catch (InstanceAlreadyExistsException e) {
            this.handleException("MBean implementation is not compliant with JMX specification standard MBean.", e, msgCtx);
        }
        catch (MBeanRegistrationException e) {
            this.handleException("Could not register MediatorCacheInvalidator MBean.", e, msgCtx);
        }
    }

    private MBeanServer getMBeanServer() {
        MBeanServer mserver = MBeanServerFactory.findMBeanServer(null).size() > 0 ? MBeanServerFactory.findMBeanServer(null).get(0) : MBeanServerFactory.createMBeanServer();
        return mserver;
    }

    public DigestGenerator getDigestGenerator() {
        return this.digestGenerator;
    }

    public void setDigestGenerator(DigestGenerator digestGenerator) {
        this.digestGenerator = digestGenerator;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isCollector() {
        return this.collector;
    }

    public void setCollector(boolean collector) {
        this.collector = collector;
    }

    public String[] getHeadersToExcludeInHash() {
        return this.headersToExcludeInHash;
    }

    public void setHeadersToExcludeInHash(String ... headersToExcludeInHash) {
        this.headersToExcludeInHash = headersToExcludeInHash;
    }

    public SequenceMediator getOnCacheHitSequence() {
        return this.onCacheHitSequence;
    }

    public void setOnCacheHitSequence(SequenceMediator onCacheHitSequence) {
        this.onCacheHitSequence = onCacheHitSequence;
    }

    public String getOnCacheHitRef() {
        return this.onCacheHitRef;
    }

    public void setOnCacheHitRef(String onCacheHitRef) {
        this.onCacheHitRef = onCacheHitRef;
    }

    public int getInMemoryCacheSize() {
        return this.inMemoryCacheSize;
    }

    public void setInMemoryCacheSize(int inMemoryCacheSize) {
        this.inMemoryCacheSize = inMemoryCacheSize;
    }

    public String[] getHTTPMethodsToCache() {
        return this.hTTPMethodsToCache;
    }

    public void setHTTPMethodsToCache(String ... hTTPMethodToCache) {
        this.hTTPMethodsToCache = hTTPMethodToCache;
    }

    public String getProtocolType() {
        return this.protocolType;
    }

    public void setProtocolType(String protocolType) {
        this.protocolType = protocolType;
    }

    public String getResponseCodes() {
        return this.responseCodes;
    }

    public void setResponseCodes(String responseCodes) {
        this.responseCodes = responseCodes;
        this.responseCodePattern = Pattern.compile(responseCodes);
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public boolean isCacheControlEnabled() {
        return this.cacheControlEnabled;
    }

    public void setCacheControlEnabled(boolean cacheControlEnabled) {
        this.cacheControlEnabled = cacheControlEnabled;
    }

    public boolean isAddAgeHeaderEnabled() {
        return this.addAgeHeaderEnabled;
    }

    public void setAddAgeHeaderEnabled(boolean addAgeHeaderEnabled) {
        this.addAgeHeaderEnabled = addAgeHeaderEnabled;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setHashGenerator(String hashGenerator) {
        this.hashGenerator = hashGenerator;
    }

    public String getHashGenerator() {
        return this.hashGenerator;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public String getScope() {
        return this.scope;
    }

    public void setImplementationType(String implementationType) {
        this.implementationType = implementationType;
    }

    public String getImplementationType() {
        return this.implementationType;
    }

    public boolean isPreviousCacheImplementation() {
        return this.isPreviousCacheImplementation;
    }

    public void setPreviousCacheImplementation(boolean previousCacheImplementation) {
        this.isPreviousCacheImplementation = previousCacheImplementation;
    }
}

