/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache.digest;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.cache.CachingException;
import org.wso2.carbon.mediator.cache.digest.DigestGenerator;

public class HttpRequestHashGenerator
implements DigestGenerator {
    static final long serialVersionUID = 42L;
    private static final Log log = LogFactory.getLog(HttpRequestHashGenerator.class);
    private static final String MD5_DIGEST_ALGORITHM = "MD5";
    private static final String EXCLUDE_ALL_VAL = "*";
    private final String charsetName = "UnicodeBigUnmarked";
    String[] headers = new String[]{""};
    String[] permanentlyExcludedHeaders = new String[0];

    @Override
    public String getDigest(MessageContext msgContext) throws CachingException {
        boolean isGet;
        boolean excludeAllHeaders = EXCLUDE_ALL_VAL.equals(this.headers[0]);
        String method = (String)msgContext.getProperty("HTTP_METHOD");
        boolean bl = isGet = msgContext.isDoingREST() && ("GET".equals(method) || "DELETE".equals(method) || "HEAD".equals(method));
        if (!excludeAllHeaders) {
            TreeMap<String, String> transportHeaders = new TreeMap<String, String>(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    return o1.compareToIgnoreCase(o2);
                }
            });
            transportHeaders.putAll((Map)msgContext.getProperty("TRANSPORT_HEADERS"));
            for (String header : this.headers) {
                transportHeaders.remove(header);
            }
            for (String header : this.permanentlyExcludedHeaders) {
                transportHeaders.remove(header);
            }
            if (isGet) {
                if (msgContext.getTo() == null) {
                    return null;
                }
                String toAddress = msgContext.getTo().getAddress();
                byte[] digest = this.getDigest(toAddress, transportHeaders, MD5_DIGEST_ALGORITHM);
                return digest != null ? this.getStringRepresentation(digest) : null;
            }
            SOAPBody body = msgContext.getEnvelope().getBody();
            String toAddress = null;
            if (msgContext.getTo() != null) {
                toAddress = msgContext.getTo().getAddress();
            }
            if (body != null) {
                byte[] digest = toAddress != null ? this.getDigest((OMNode)body, toAddress, transportHeaders, MD5_DIGEST_ALGORITHM) : this.getDigest((OMNode)body, MD5_DIGEST_ALGORITHM);
                return digest != null ? this.getStringRepresentation(digest) : null;
            }
            return null;
        }
        if (isGet) {
            if (msgContext.getTo() == null) {
                return null;
            }
            String toAddress = msgContext.getTo().getAddress();
            byte[] digest = this.getDigest(toAddress, MD5_DIGEST_ALGORITHM);
            return digest != null ? this.getStringRepresentation(digest) : null;
        }
        SOAPBody body = msgContext.getEnvelope().getBody();
        String toAddress = null;
        if (msgContext.getTo() != null) {
            toAddress = msgContext.getTo().getAddress();
        }
        if (body != null) {
            byte[] digest = toAddress != null ? this.getDigest((OMNode)body, toAddress, null, MD5_DIGEST_ALGORITHM) : this.getDigest((OMNode)body, MD5_DIGEST_ALGORITHM);
            return digest != null ? this.getStringRepresentation(digest) : null;
        }
        return null;
    }

    public byte[] getDigest(String toAddress, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update(toAddress.getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
        }
        return digest;
    }

    public byte[] getDigest(OMNode node, String digestAlgorithm) throws CachingException {
        if (node.getType() == 1) {
            return this.getDigest(node, digestAlgorithm);
        }
        if (node.getType() == 4) {
            return this.getDigest((OMText)node, digestAlgorithm);
        }
        if (node.getType() == 3) {
            return this.getDigest((OMProcessingInstruction)node, digestAlgorithm);
        }
        return new byte[0];
    }

    public byte[] getDigest(OMNode node, String toAddress, Map<String, String> headers, String digestAlgorithm) throws CachingException {
        if (node.getType() == 1) {
            return this.getDigest((OMElement)node, toAddress, headers, digestAlgorithm);
        }
        if (node.getType() == 4) {
            return this.getDigest((OMText)node, digestAlgorithm);
        }
        if (node.getType() == 3) {
            return this.getDigest((OMProcessingInstruction)node, digestAlgorithm);
        }
        return new byte[0];
    }

    private byte[] getDigest(String toAddress, Map<String, String> transportHeaders, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.write(toAddress.getBytes("UnicodeBigUnmarked"));
            for (Map.Entry<String, String> entry : transportHeaders.entrySet()) {
                dos.write(this.getDigest(entry.getKey(), entry.getValue(), digestAlgorithm));
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (IOException e) {
            this.handleException("Error in calculating the digest value for the headers", e);
        }
        return digest;
    }

    public byte[] getDigest(String key, String value, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        if (!key.equalsIgnoreCase("Date") && !key.equalsIgnoreCase("User-Agent")) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)2);
                md.update(key.getBytes("UnicodeBigUnmarked"));
                if (value != null) {
                    md.update((byte)0);
                    md.update((byte)0);
                    md.update(value.getBytes("UnicodeBigUnmarked"));
                }
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException e) {
                this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
            }
            catch (UnsupportedEncodingException e) {
                this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
            }
        }
        return digest;
    }

    public String getStringRepresentation(byte[] array) {
        StringBuffer strBuff = new StringBuffer(array.length);
        for (int i = 0; i < array.length; ++i) {
            strBuff.append(array[i]);
        }
        return strBuff.toString();
    }

    private void handleException(String message, Throwable cause) throws CachingException {
        log.debug((Object)message, cause);
        throw new CachingException(message, cause);
    }

    public byte[] getDigest(OMElement element, String toAddress, Map<String, String> headers, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1);
            dos.write(this.getExpandedName(element).getBytes("UnicodeBigUnmarked"));
            dos.write(0);
            dos.write(0);
            dos.write(toAddress.getBytes("UnicodeBigUnmarked"));
            if (headers != null) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    dos.write(this.getDigest(entry.getKey(), entry.getValue(), digestAlgorithm));
                }
            }
            Collection attrs = this.getAttributesWithoutNS(element);
            dos.writeInt(attrs.size());
            Iterator itr = attrs.iterator();
            while (itr.hasNext()) {
                dos.write(this.getDigest((OMAttribute)itr.next(), digestAlgorithm));
            }
            OMNode node = element.getFirstOMChild();
            int length = 0;
            itr = element.getChildElements();
            while (itr.hasNext()) {
                ++length;
                itr.next();
            }
            dos.writeInt(length);
            while (node != null) {
                dos.write(this.getDigest(node, toAddress, headers, digestAlgorithm));
                node = node.getNextOMSibling();
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (IOException e) {
            this.handleException("Error in calculating the digest value for the OMElement : " + element, e);
        }
        return digest;
    }

    public byte[] getDigest(OMText text, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)3);
            md.update(text.getText().getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
        }
        return digest;
    }

    public byte[] getDigest(OMProcessingInstruction pi, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)7);
            md.update(pi.getTarget().getBytes("UnicodeBigUnmarked"));
            md.update((byte)0);
            md.update((byte)0);
            md.update(pi.getValue().getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
        }
        return digest;
    }

    public byte[] getDigest(OMAttribute attribute, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        if (!attribute.getLocalName().equals("xmlns") && !attribute.getLocalName().startsWith("xmlns:")) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)2);
                md.update(this.getExpandedName(attribute).getBytes("UnicodeBigUnmarked"));
                md.update((byte)0);
                md.update((byte)0);
                md.update(attribute.getAttributeValue().getBytes("UnicodeBigUnmarked"));
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException e) {
                this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
            }
            catch (UnsupportedEncodingException e) {
                this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
            }
        }
        return digest;
    }

    public String getExpandedName(OMElement element) {
        if (element.getNamespace() != null) {
            return element.getNamespace().getNamespaceURI() + ":" + element.getLocalName();
        }
        return element.getLocalName();
    }

    public String getExpandedName(OMAttribute attribute) {
        if (attribute.getNamespace() != null) {
            return attribute.getNamespace().getNamespaceURI() + ":" + attribute.getLocalName();
        }
        return attribute.getLocalName();
    }

    public Collection getAttributesWithoutNS(OMElement element) {
        TreeMap<String, OMAttribute> map = new TreeMap<String, OMAttribute>();
        Iterator itr = element.getAllAttributes();
        while (itr.hasNext()) {
            OMAttribute attribute = (OMAttribute)itr.next();
            if (attribute.getLocalName().equals("xmlns") || attribute.getLocalName().startsWith("xmlns:")) continue;
            map.put(this.getExpandedName(attribute), attribute);
        }
        return map.values();
    }

    @Override
    public void init(Map<String, Object> properties) {
        this.headers = (String[])properties.get("headers-to-exclude");
        this.permanentlyExcludedHeaders = (String[])properties.get("permanently-excluded-headers");
    }
}

