/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache.digest;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMProcessingInstruction;
import org.apache.axiom.om.OMText;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.cache.CachingException;
import org.wso2.carbon.mediator.cache.digest.DigestGenerator;

@Deprecated
public class DOMHASHGenerator
implements DigestGenerator {
    public static final String MD5_DIGEST_ALGORITHM = "MD5";
    public static final String SHA_DIGEST_ALGORITHM = "SHA";
    public static final String SHA1_DIGEST_ALGORITHM = "SHA1";
    private static final Log log = LogFactory.getLog(DOMHASHGenerator.class);

    @Override
    public void init(Map<String, Object> properties) {
    }

    @Override
    public String getDigest(MessageContext msgContext) throws CachingException {
        SOAPBody request = msgContext.getEnvelope().getBody();
        if (request != null) {
            byte[] digest = this.getDigest((OMNode)request, MD5_DIGEST_ALGORITHM);
            return digest != null ? this.getStringRepresentation(digest) : null;
        }
        return null;
    }

    public byte[] getDigest(OMNode node, String digestAlgorithm) throws CachingException {
        if (node.getType() == 1) {
            return this.getDigest((OMElement)node, digestAlgorithm);
        }
        if (node.getType() == 4) {
            return this.getDigest((OMText)node, digestAlgorithm);
        }
        if (node.getType() == 3) {
            return this.getDigest((OMProcessingInstruction)node, digestAlgorithm);
        }
        return new byte[0];
    }

    public byte[] getDigest(OMDocument document, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(9);
            Collection childNodes = this.getValidElements(document);
            dos.writeInt(childNodes.size());
            for (OMNode node : childNodes) {
                if (node.getType() == 3) {
                    dos.write(this.getDigest((OMProcessingInstruction)node, digestAlgorithm));
                    continue;
                }
                if (node.getType() != 1) continue;
                dos.write(this.getDigest((OMElement)node, digestAlgorithm));
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (IOException e) {
            this.handleException("Error in calculating the digest value for the OMDocument : " + document, e);
        }
        return digest;
    }

    public byte[] getDigest(OMElement element, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            dos.writeInt(1);
            dos.write(this.getExpandedName(element).getBytes("UnicodeBigUnmarked"));
            dos.write(0);
            dos.write(0);
            Collection attrs = this.getAttributesWithoutNS(element);
            dos.writeInt(attrs.size());
            Iterator itr = attrs.iterator();
            while (itr.hasNext()) {
                dos.write(this.getDigest((OMAttribute)itr.next(), digestAlgorithm));
            }
            OMNode node = element.getFirstOMChild();
            int length = 0;
            itr = element.getChildElements();
            while (itr.hasNext()) {
                ++length;
                itr.next();
            }
            dos.writeInt(length);
            while (node != null) {
                dos.write(this.getDigest(node, digestAlgorithm));
                node = node.getNextOMSibling();
            }
            dos.close();
            md.update(baos.toByteArray());
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (IOException e) {
            this.handleException("Error in calculating the digest value for the OMElement : " + element, e);
        }
        return digest;
    }

    public byte[] getDigest(OMProcessingInstruction pi, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)7);
            md.update(pi.getTarget().getBytes("UnicodeBigUnmarked"));
            md.update((byte)0);
            md.update((byte)0);
            md.update(pi.getValue().getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
        }
        return digest;
    }

    public byte[] getDigest(OMAttribute attribute, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        if (!attribute.getLocalName().equals("xmlns") && !attribute.getLocalName().startsWith("xmlns:")) {
            try {
                MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)0);
                md.update((byte)2);
                md.update(this.getExpandedName(attribute).getBytes("UnicodeBigUnmarked"));
                md.update((byte)0);
                md.update((byte)0);
                md.update(attribute.getAttributeValue().getBytes("UnicodeBigUnmarked"));
                digest = md.digest();
            }
            catch (NoSuchAlgorithmException e) {
                this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
            }
            catch (UnsupportedEncodingException e) {
                this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
            }
        }
        return digest;
    }

    public byte[] getDigest(OMText text, String digestAlgorithm) throws CachingException {
        byte[] digest = new byte[]{};
        try {
            MessageDigest md = MessageDigest.getInstance(digestAlgorithm);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)0);
            md.update((byte)3);
            md.update(text.getText().getBytes("UnicodeBigUnmarked"));
            digest = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            this.handleException("Can not locate the algorithm provided for the digest generation : " + digestAlgorithm, e);
        }
        catch (UnsupportedEncodingException e) {
            this.handleException("Error in generating the digest using the provided encoding : UnicodeBigUnmarked", e);
        }
        return digest;
    }

    public String getExpandedName(OMElement element) {
        if (element.getNamespace() != null) {
            return element.getNamespace().getNamespaceURI() + ":" + element.getLocalName();
        }
        return element.getLocalName();
    }

    public String getExpandedName(OMAttribute attribute) {
        if (attribute.getNamespace() != null) {
            return attribute.getNamespace().getNamespaceURI() + ":" + attribute.getLocalName();
        }
        return attribute.getLocalName();
    }

    public Collection getAttributesWithoutNS(OMElement element) {
        TreeMap<String, OMAttribute> map = new TreeMap<String, OMAttribute>();
        Iterator itr = element.getAllAttributes();
        while (itr.hasNext()) {
            OMAttribute attribute = (OMAttribute)itr.next();
            if (attribute.getLocalName().equals("xmlns") || attribute.getLocalName().startsWith("xmlns:")) continue;
            map.put(this.getExpandedName(attribute), attribute);
        }
        return map.values();
    }

    public Collection getValidElements(OMDocument document) {
        ArrayList<OMNode> list = new ArrayList<OMNode>();
        Iterator itr = document.getChildren();
        while (itr.hasNext()) {
            OMNode node = (OMNode)itr.next();
            if (node.getType() != 1 && node.getType() != 3) continue;
            list.add(node);
        }
        return list;
    }

    public String getStringRepresentation(byte[] array) {
        StringBuffer strBuff = new StringBuffer(array.length);
        for (int i = 0; i < array.length; ++i) {
            strBuff.append(array[i]);
        }
        return strBuff.toString();
    }

    public boolean compareOMNode(OMNode node, OMNode comparingNode, String digestAlgorithm) throws CachingException {
        return Arrays.equals(this.getDigest(node, digestAlgorithm), this.getDigest(comparingNode, digestAlgorithm));
    }

    public boolean compareOMDocument(OMDocument document, OMDocument comparingDocument, String digestAlgorithm) throws CachingException {
        return Arrays.equals(this.getDigest(document, digestAlgorithm), this.getDigest(comparingDocument, digestAlgorithm));
    }

    public boolean compareOMAttribute(OMAttribute attribute, OMAttribute comparingAttribute, String digestAlgorithm) throws CachingException {
        return Arrays.equals(this.getDigest(attribute, digestAlgorithm), this.getDigest(comparingAttribute, digestAlgorithm));
    }

    private void handleException(String message, Throwable cause) throws CachingException {
        log.debug((Object)message, cause);
        throw new CachingException(message, cause);
    }
}

