/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.wso2.carbon.mediator.cache.CachableResponse;

public class HttpCachingFilter {
    private HttpCachingFilter() {
    }

    public static boolean isValidCacheEntry(CachableResponse cachedResponse, org.apache.synapse.MessageContext synCtx) {
        Map<String, Object> httpHeaders = cachedResponse.getHeaderProperties();
        MessageContext msgCtx = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String eTagValue = null;
        boolean isNoCache = false;
        long maxAge = -1L;
        if (httpHeaders != null) {
            eTagValue = HttpCachingFilter.getETagValue(httpHeaders);
            if (httpHeaders.get("Cache-Control") != null) {
                String cacheControlHeaderValue = String.valueOf(httpHeaders.get("Cache-Control"));
                List<String> cacheControlHeaders = Arrays.asList(cacheControlHeaderValue.split("\\s*,\\s*"));
                for (String cacheControlHeader : cacheControlHeaders) {
                    if ("no-cache".equalsIgnoreCase(cacheControlHeader)) {
                        isNoCache = true;
                    }
                    if (!cacheControlHeader.contains("max-age")) continue;
                    maxAge = Long.parseLong(cacheControlHeader.split("=")[1]);
                }
            }
        }
        return HttpCachingFilter.isCachedResponseExpired(cachedResponse, maxAge) || HttpCachingFilter.isValidateResponseWithETag(msgCtx, eTagValue, isNoCache);
    }

    private static boolean isValidateResponseWithETag(MessageContext msgCtx, String eTagValue, boolean isNoCache) {
        if (isNoCache && StringUtils.isNotEmpty((String)eTagValue)) {
            HashMap<String, String> headerProp = new HashMap<String, String>();
            headerProp.put("IF-None-Match", eTagValue);
            msgCtx.setProperty("TRANSPORT_HEADERS", headerProp);
            return true;
        }
        return false;
    }

    private static boolean isCachedResponseExpired(CachableResponse cachedResponse, long maxAge) {
        long responseExpirationTime;
        return maxAge > -1L && (responseExpirationTime = cachedResponse.getResponseFetchedTime() + maxAge * 1000L) < System.currentTimeMillis();
    }

    private static String getETagValue(Map<String, Object> httpHeaders) {
        if (httpHeaders.get("ETag") != null) {
            return String.valueOf(httpHeaders.get("ETag"));
        }
        return null;
    }

    public static void setAgeHeader(CachableResponse cachedResponse, MessageContext msgCtx) {
        MultiValueMap excessHeaders = new MultiValueMap();
        long responseCachedTime = cachedResponse.getResponseFetchedTime();
        long age = Math.abs((responseCachedTime - System.currentTimeMillis()) / 1000L);
        excessHeaders.put("Age", String.valueOf(age));
        msgCtx.setProperty("EXCESS_TRANSPORT_HEADERS", (Object)excessHeaders);
    }

    public static void setResponseCachedTime(Map<String, String> headers, CachableResponse response) throws ParseException {
        long responseFetchedTime;
        String dateHeaderValue;
        if (headers != null && (dateHeaderValue = headers.get("Date")) != null) {
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
            Date d = format.parse(dateHeaderValue);
            responseFetchedTime = d.getTime();
        } else {
            responseFetchedTime = System.currentTimeMillis();
        }
        response.setResponseFetchedTime(responseFetchedTime);
    }

    public static boolean isNoStore(MessageContext msgCtx) {
        ConcurrentHashMap headerProperties = new ConcurrentHashMap();
        Map headers = (Map)msgCtx.getProperty("TRANSPORT_HEADERS");
        String cacheControlHeaderValue = null;
        for (Map.Entry entry : headers.entrySet()) {
            headerProperties.put(entry.getKey(), entry.getValue());
        }
        if (headerProperties.get("Cache-Control") != null) {
            cacheControlHeaderValue = String.valueOf(headerProperties.get("Cache-Control"));
        }
        return StringUtils.isNotEmpty(cacheControlHeaderValue) && cacheControlHeaderValue.contains("no-store");
    }
}

