/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache;

import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializer;
import org.apache.synapse.config.xml.MediatorSerializerFinder;
import org.wso2.carbon.mediator.cache.CacheMediator;

public class CacheMediatorSerializer
extends AbstractMediatorSerializer {
    protected OMElement serializeSpecificMediator(Mediator mediator) {
        if (!(mediator instanceof CacheMediator)) {
            this.handleException("Unsupported mediator passed in for serialization : " + mediator.getType());
        }
        CacheMediator cacheMediator = (CacheMediator)mediator;
        OMElement cacheElem = fac.createOMElement("cache", synNS);
        CacheMediatorSerializer.saveTracingState((OMElement)cacheElem, (Mediator)mediator);
        boolean isPreviousCacheImplementation = cacheMediator.isPreviousCacheImplementation();
        if (cacheMediator.isCollector()) {
            cacheElem.addAttribute(fac.createOMAttribute("collector", nullNS, "true"));
            if (isPreviousCacheImplementation) {
                cacheElem.addAttribute(fac.createOMAttribute("scope", nullNS, cacheMediator.getScope()));
            }
        } else {
            OMElement onCacheHit;
            cacheElem.addAttribute(fac.createOMAttribute("collector", nullNS, "false"));
            if (cacheMediator.getTimeout() > -1L) {
                cacheElem.addAttribute(fac.createOMAttribute("timeout", nullNS, Long.toString(cacheMediator.getTimeout())));
            }
            if (cacheMediator.getMaxMessageSize() > -1) {
                cacheElem.addAttribute(fac.createOMAttribute("maxMessageSize", nullNS, Integer.toString(cacheMediator.getMaxMessageSize())));
            }
            if (isPreviousCacheImplementation) {
                if (!cacheMediator.getId().trim().isEmpty()) {
                    cacheElem.addAttribute(fac.createOMAttribute("id", nullNS, cacheMediator.getId()));
                }
                cacheElem.addAttribute(fac.createOMAttribute("hashGenerator", nullNS, cacheMediator.getHashGenerator()));
                cacheElem.addAttribute(fac.createOMAttribute("scope", nullNS, cacheMediator.getScope()));
            }
            if (cacheMediator.getOnCacheHitRef() != null) {
                onCacheHit = fac.createOMElement("onCacheHit", synNS);
                onCacheHit.addAttribute(fac.createOMAttribute("sequence", nullNS, cacheMediator.getOnCacheHitRef()));
                cacheElem.addChild((OMNode)onCacheHit);
            } else if (cacheMediator.getOnCacheHitSequence() != null) {
                onCacheHit = fac.createOMElement("onCacheHit", synNS);
                this.serializeChildren(onCacheHit, cacheMediator.getOnCacheHitSequence().getList());
                cacheElem.addChild((OMNode)onCacheHit);
            }
            if (!isPreviousCacheImplementation) {
                OMElement protocolElem = fac.createOMElement("protocol", synNS);
                protocolElem.addAttribute(fac.createOMAttribute("type", nullNS, cacheMediator.getProtocolType()));
                if ("HTTP".equals(cacheMediator.getProtocolType())) {
                    String[] includeHeaders;
                    String[] excludeHeaders;
                    String[] methods = cacheMediator.getHTTPMethodsToCache();
                    if (methods.length != 0 || !methods[0].isEmpty()) {
                        StringBuilder method = new StringBuilder();
                        for (int i = 0; i < methods.length; ++i) {
                            if (i != methods.length - 1) {
                                method.append(methods[i]).append(", ");
                                continue;
                            }
                            method.append(methods[i]);
                        }
                        OMElement methodElem = fac.createOMElement("methods", synNS);
                        methodElem.setText(method.toString());
                        protocolElem.addChild((OMNode)methodElem);
                    }
                    if ((excludeHeaders = cacheMediator.getHeadersToExcludeInHash()).length != 0 || !excludeHeaders[0].isEmpty()) {
                        StringBuilder header = new StringBuilder();
                        for (int i = 0; i < excludeHeaders.length; ++i) {
                            if (i != excludeHeaders.length - 1) {
                                header.append(excludeHeaders[i]).append(", ");
                                continue;
                            }
                            header.append(excludeHeaders[i]);
                        }
                        OMElement headerElem = fac.createOMElement("headersToExcludeInHash", synNS);
                        headerElem.setText(header.toString());
                        protocolElem.addChild((OMNode)headerElem);
                    }
                    if ((includeHeaders = cacheMediator.getHeadersToIncludeInHash()).length != 0 || !includeHeaders[0].isEmpty()) {
                        StringBuilder header = new StringBuilder();
                        for (int i = 0; i < includeHeaders.length; ++i) {
                            if (i != includeHeaders.length - 1) {
                                header.append(includeHeaders[i]).append(", ");
                                continue;
                            }
                            header.append(includeHeaders[i]);
                        }
                        OMElement headerElem = fac.createOMElement("headersToIncludeInHash", synNS);
                        headerElem.setText(header.toString());
                        protocolElem.addChild((OMNode)headerElem);
                    }
                    String responseCodes = cacheMediator.getResponseCodes();
                    OMElement responseCodesElem = fac.createOMElement("responseCodes", synNS);
                    responseCodesElem.setText(responseCodes);
                    protocolElem.addChild((OMNode)responseCodesElem);
                    boolean cacheControlEnabled = cacheMediator.isCacheControlEnabled();
                    OMElement enableCacheControlElem = fac.createOMElement("enableCacheControl", synNS);
                    enableCacheControlElem.setText(String.valueOf(cacheControlEnabled));
                    protocolElem.addChild((OMNode)enableCacheControlElem);
                    boolean addAgeHeaderEnabled = cacheMediator.isAddAgeHeaderEnabled();
                    OMElement addAgeHeaderEnabledElem = fac.createOMElement("includeAgeHeader", synNS);
                    addAgeHeaderEnabledElem.setText(String.valueOf(addAgeHeaderEnabled));
                    protocolElem.addChild((OMNode)addAgeHeaderEnabledElem);
                }
                OMElement hashGeneratorElem = fac.createOMElement("hashGenerator", synNS);
                hashGeneratorElem.setText(cacheMediator.getDigestGenerator().getClass().getName());
                protocolElem.addChild((OMNode)hashGeneratorElem);
                cacheElem.addChild((OMNode)protocolElem);
            }
            if (cacheMediator.getInMemoryCacheSize() > -1) {
                OMElement implElem = fac.createOMElement("implementation", synNS);
                implElem.addAttribute(fac.createOMAttribute("maxSize", nullNS, Integer.toString(cacheMediator.getInMemoryCacheSize())));
                if (isPreviousCacheImplementation) {
                    implElem.addAttribute(fac.createOMAttribute("type", nullNS, cacheMediator.getImplementationType()));
                }
                cacheElem.addChild((OMNode)implElem);
            }
        }
        this.serializeComments(cacheElem, cacheMediator.getCommentsList());
        return cacheElem;
    }

    public String getMediatorClassName() {
        return CacheMediator.class.getName();
    }

    protected void serializeChildren(OMElement parent, List<Mediator> list) {
        for (Mediator child : list) {
            MediatorSerializer medSer = MediatorSerializerFinder.getInstance().getSerializer(child);
            if (medSer != null) {
                medSer.serializeMediator(parent, child);
                continue;
            }
            this.handleException("Unable to find a serializer for mediator : " + child.getType());
        }
    }
}

