/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.commons.lang.StringUtils;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SequenceMediatorFactory;
import org.wso2.carbon.mediator.cache.CacheManager;
import org.wso2.carbon.mediator.cache.CacheMediator;
import org.wso2.carbon.mediator.cache.CachingConstants;
import org.wso2.carbon.mediator.cache.digest.DigestGenerator;

public class CacheMediatorFactory
extends AbstractMediatorFactory {
    private static final QName ATT_TIMEOUT = new QName("timeout");
    private static final QName ATT_COLLECTOR = new QName("collector");
    private static final QName ATT_MAX_MSG_SIZE = new QName("maxMessageSize");
    private static final QName ON_CACHE_HIT_Q = new QName("http://ws.apache.org/ns/synapse", "onCacheHit");
    private static final QName ATT_SEQUENCE = new QName("sequence");
    private static final QName PROTOCOL_Q = new QName("http://ws.apache.org/ns/synapse", "protocol");
    private static final QName ATT_TYPE = new QName("type");
    private static final QName HTTP_METHODS_TO_CACHE_Q = new QName("http://ws.apache.org/ns/synapse", "methods");
    private static final QName HEADERS_TO_EXCLUDE_IN_HASH_Q = new QName("http://ws.apache.org/ns/synapse", "headersToExcludeInHash");
    private static final QName HEADERS_TO_INCLUDE_IN_HASH_Q = new QName("http://ws.apache.org/ns/synapse", "headersToIncludeInHash");
    private static final QName RESPONSE_CODES_Q = new QName("http://ws.apache.org/ns/synapse", "responseCodes");
    private static final QName HASH_GENERATOR_Q = new QName("http://ws.apache.org/ns/synapse", "hashGenerator");
    private static final QName ATT_HASH_GENERATOR = new QName("hashGenerator");
    private static final QName IMPLEMENTATION_Q = new QName("http://ws.apache.org/ns/synapse", "implementation");
    private static final QName ATT_SIZE = new QName("maxSize");
    private static final QName ENABLE_CACHE_CONTROL_Q = new QName("http://ws.apache.org/ns/synapse", "enableCacheControl");
    private static final QName INCLUDE_AGE_HEADER_Q = new QName("http://ws.apache.org/ns/synapse", "includeAgeHeader");
    private static final QName ATT_ID = new QName("id");
    private static final QName ATT_SCOPE = new QName("scope");
    private final CacheManager cacheManager = new CacheManager();

    protected Mediator createSpecificMediator(OMElement elem, Properties properties) {
        if (!CachingConstants.CACHE_Q.equals(elem.getQName())) {
            this.handleException("Unable to create the cache mediator. Unexpected element as the cache mediator configuration");
        }
        CacheMediator cache = new CacheMediator(this.cacheManager);
        OMAttribute collectorAttr = elem.getAttribute(ATT_COLLECTOR);
        if (collectorAttr != null && collectorAttr.getAttributeValue() != null) {
            if ("true".equals(collectorAttr.getAttributeValue())) {
                cache.setCollector(true);
                OMAttribute scopeAttribute = elem.getAttribute(ATT_SCOPE);
                if (scopeAttribute != null && scopeAttribute.getAttributeValue() != null) {
                    cache.setScope(scopeAttribute.getAttributeValue().trim());
                }
            } else if ("false".equals(collectorAttr.getAttributeValue())) {
                HashMap<String, Object> props;
                block57: {
                    OMAttribute scopeAttribute;
                    OMAttribute hashGeneratorAttribute;
                    cache.setCollector(false);
                    OMAttribute timeoutAttr = elem.getAttribute(ATT_TIMEOUT);
                    if (timeoutAttr != null && timeoutAttr.getAttributeValue() != null) {
                        cache.setTimeout(Long.parseLong(timeoutAttr.getAttributeValue().trim()));
                    } else {
                        cache.setTimeout(5000L);
                    }
                    OMAttribute maxMessageSizeAttr = elem.getAttribute(ATT_MAX_MSG_SIZE);
                    if (maxMessageSizeAttr != null && maxMessageSizeAttr.getAttributeValue() != null) {
                        cache.setMaxMessageSize(Integer.parseInt(maxMessageSizeAttr.getAttributeValue().trim()));
                    } else {
                        cache.setMaxMessageSize(-1);
                    }
                    OMAttribute idAttribute = elem.getAttribute(ATT_ID);
                    if (idAttribute != null && idAttribute.getAttributeValue() != null) {
                        cache.setId(idAttribute.getAttributeValue().trim());
                    }
                    if ((hashGeneratorAttribute = elem.getAttribute(ATT_HASH_GENERATOR)) != null && hashGeneratorAttribute.getAttributeValue() != null) {
                        cache.setHashGenerator(hashGeneratorAttribute.getAttributeValue().trim());
                    }
                    if ((scopeAttribute = elem.getAttribute(ATT_SCOPE)) != null && scopeAttribute.getAttributeValue() != null) {
                        cache.setScope(scopeAttribute.getAttributeValue().trim());
                    }
                    String className = null;
                    OMElement protocolElem = elem.getFirstChildWithName(PROTOCOL_Q);
                    props = new HashMap<String, Object>();
                    if (protocolElem != null) {
                        OMAttribute typeAttr = protocolElem.getAttribute(ATT_TYPE);
                        if (typeAttr != null && typeAttr.getAttributeValue() != null) {
                            OMElement hashGeneratorElem = protocolElem.getFirstChildWithName(HASH_GENERATOR_Q);
                            if (hashGeneratorElem != null) {
                                className = hashGeneratorElem.getText();
                            }
                            String protocolType = typeAttr.getAttributeValue().toUpperCase().trim();
                            cache.setProtocolType(protocolType);
                            if ("HTTP".equals(protocolType)) {
                                OMElement methodElem = protocolElem.getFirstChildWithName(HTTP_METHODS_TO_CACHE_Q);
                                if (methodElem != null) {
                                    String[] methods = methodElem.getText().split(",");
                                    if (!"".equals(methods[0])) {
                                        for (int i = 0; i < methods.length; ++i) {
                                            methods[i] = methods[i].toUpperCase().trim();
                                            if ("POST".equals(methods[i]) || "GET".equals(methods[i]) || "HEAD".equals(methods[i]) || "PUT".equals(methods[i]) || "DELETE".equals(methods[i]) || "OPTIONS".equals(methods[i]) || "CONNECT".equals(methods[i]) || "PATCH".equals(methods[i]) || "*".equals(methods[i])) continue;
                                            this.handleException("Unexpected method type: " + methods[i]);
                                        }
                                        cache.setHTTPMethodsToCache(methods);
                                    }
                                } else {
                                    cache.setHTTPMethodsToCache("*");
                                }
                                OMElement headersToIncludeInHash = protocolElem.getFirstChildWithName(HEADERS_TO_INCLUDE_IN_HASH_Q);
                                if (headersToIncludeInHash != null) {
                                    String[] headers = headersToIncludeInHash.getText().split(",");
                                    for (int i = 0; i < headers.length; ++i) {
                                        headers[i] = headers[i].trim();
                                    }
                                    cache.setHeadersToIncludeInHash(headers);
                                } else {
                                    cache.setHeadersToIncludeInHash("");
                                }
                                OMElement headersToExcludeInHash = protocolElem.getFirstChildWithName(HEADERS_TO_EXCLUDE_IN_HASH_Q);
                                if (headersToExcludeInHash != null) {
                                    String[] headers = headersToExcludeInHash.getText().split(",");
                                    for (int i = 0; i < headers.length; ++i) {
                                        headers[i] = headers[i].trim();
                                    }
                                    cache.setHeadersToExcludeInHash(headers);
                                } else {
                                    cache.setHeadersToExcludeInHash("");
                                }
                                OMElement responseCodesElem = protocolElem.getFirstChildWithName(RESPONSE_CODES_Q);
                                if (responseCodesElem != null) {
                                    String responses = responseCodesElem.getText();
                                    if (!"".equals(responses) && responses != null) {
                                        cache.setResponseCodes(responses);
                                    }
                                } else {
                                    cache.setResponseCodes(".*");
                                }
                                OMElement enableCacheControlElem = protocolElem.getFirstChildWithName(ENABLE_CACHE_CONTROL_Q);
                                if (enableCacheControlElem != null) {
                                    String cacheControlElemText = enableCacheControlElem.getText();
                                    if (StringUtils.isNotEmpty((String)cacheControlElemText)) {
                                        cache.setCacheControlEnabled(Boolean.parseBoolean(cacheControlElemText));
                                    }
                                } else {
                                    cache.setCacheControlEnabled(false);
                                }
                                OMElement addAgeHeaderElem = protocolElem.getFirstChildWithName(INCLUDE_AGE_HEADER_Q);
                                if (addAgeHeaderElem != null) {
                                    String addAgeHeaderElemText = addAgeHeaderElem.getText();
                                    if (StringUtils.isNotEmpty((String)addAgeHeaderElemText)) {
                                        cache.setAddAgeHeaderEnabled(Boolean.parseBoolean(addAgeHeaderElemText));
                                    }
                                } else {
                                    cache.setCacheControlEnabled(false);
                                }
                                props.put("headers-to-include", cache.getHeadersToIncludeInHash());
                                props.put("headers-to-exclude", cache.getHeadersToExcludeInHash());
                            }
                        } else {
                            cache.setProtocolType("HTTP");
                        }
                    } else {
                        OMAttribute hashGeneratorAttr = elem.getAttribute(ATT_HASH_GENERATOR);
                        if (hashGeneratorAttr != null && hashGeneratorAttr.getAttributeValue() != null) {
                            className = hashGeneratorAttr.getAttributeValue();
                        }
                    }
                    if (className != null && !"".equals(className)) {
                        try {
                            Class<?> generator = Class.forName(className);
                            Object o = generator.newInstance();
                            if (o instanceof DigestGenerator) {
                                cache.setDigestGenerator((DigestGenerator)o);
                                break block57;
                            }
                            this.handleException("Specified class for the hashGenerator is not a DigestGenerator. It *must* implement org.wso2.carbon.mediator.cache.digest.DigestGenerator interface");
                        }
                        catch (ClassNotFoundException e) {
                            this.handleException("Unable to load the hash generator class", e);
                        }
                        catch (IllegalAccessException e) {
                            this.handleException("Unable to access the hash generator class", e);
                        }
                        catch (InstantiationException e) {
                            this.handleException("Unable to instantiate the hash generator class", e);
                        }
                    } else {
                        cache.setDigestGenerator(CachingConstants.DEFAULT_HASH_GENERATOR);
                    }
                }
                props.put("permanently-excluded-headers", CachingConstants.PERMANENTLY_EXCLUDED_HEADERS);
                cache.getDigestGenerator().init(props);
                OMElement onCacheHitElem = elem.getFirstChildWithName(ON_CACHE_HIT_Q);
                if (onCacheHitElem != null) {
                    OMAttribute sequenceAttr = onCacheHitElem.getAttribute(ATT_SEQUENCE);
                    if (sequenceAttr != null && sequenceAttr.getAttributeValue() != null) {
                        cache.setOnCacheHitRef(sequenceAttr.getAttributeValue());
                    } else if (onCacheHitElem.getFirstElement() != null) {
                        cache.setOnCacheHitSequence(new SequenceMediatorFactory().createAnonymousSequence(onCacheHitElem, properties));
                    }
                } else {
                    cache.setOnCacheHitRef(null);
                    cache.setOnCacheHitSequence(null);
                }
                OMElement implElem = elem.getFirstChildWithName(IMPLEMENTATION_Q);
                if (implElem != null) {
                    OMAttribute sizeAttr = implElem.getAttribute(ATT_SIZE);
                    if (sizeAttr != null && sizeAttr.getAttributeValue() != null) {
                        cache.setInMemoryCacheSize(Integer.parseInt(sizeAttr.getAttributeValue().trim()));
                    } else {
                        cache.setInMemoryCacheSize(-1);
                    }
                    OMAttribute typeAttribute = implElem.getAttribute(ATT_TYPE);
                    if (typeAttribute != null && typeAttribute.getAttributeValue() != null) {
                        cache.setImplementationType(typeAttribute.getAttributeValue().trim());
                    }
                }
            } else {
                this.handleException("The value for collector has to be either true or false");
            }
        } else {
            this.handleException("The collector attribute must be specified");
        }
        CacheMediatorFactory.addAllCommentChildrenToList((OMElement)elem, (List)cache.getCommentsList());
        return cache;
    }

    public QName getTagQName() {
        return CachingConstants.CACHE_Q;
    }
}

