/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.cache;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediator.cache.CacheManager;
import org.wso2.carbon.mediator.cache.MediatorCacheInvalidatorMBean;

public class MediatorCacheInvalidator
implements MediatorCacheInvalidatorMBean {
    private static final Log log = LogFactory.getLog(MediatorCacheInvalidator.class);
    private String tenantDomain;
    private int tenantId;
    private MessageContext msgCtx;
    private CacheManager cacheManager;

    public MediatorCacheInvalidator(CacheManager cacheManager, String tenantDomain, int tenantId, MessageContext msgCtx) {
        this.tenantDomain = tenantDomain;
        this.tenantId = tenantId;
        this.msgCtx = msgCtx;
        this.cacheManager = cacheManager;
    }

    @Override
    public void invalidateTheWholeCache() {
        if (PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain() == null) {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.getTenantDomain());
        }
        if (PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId() == -1) {
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.getTenantId());
        }
        this.cacheManager.clean();
        log.info((Object)"Total mediator cache has been invalidated.");
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }

    public void setTenantDomain(String tenantDomain) {
        this.tenantDomain = tenantDomain;
    }

    public int getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(int tenantId) {
        this.tenantId = tenantId;
    }

    public MessageContext getMsgCtx() {
        return this.msgCtx;
    }

    public void setMsgCtx(MessageContext msgCtx) {
        this.msgCtx = msgCtx;
    }
}

