/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.entitlement;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.entitlement.AdviceMediator;
import org.wso2.carbon.mediator.entitlement.ObligationsMediator;
import org.wso2.carbon.mediator.entitlement.OnAcceptMediator;
import org.wso2.carbon.mediator.entitlement.OnRejectMediator;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;

public class EntitlementMediator
extends AbstractListMediator {
    private String remoteServiceUserName;
    private String remoteServicePassword;
    private String remoteServiceUrl;
    private String remoteServiceUserNameKey;
    private String remoteServicePasswordKey;
    private String remoteServiceUrlKey;
    private String callbackClass;
    private String thriftHost;
    private String thriftPort;
    private String client;
    private static final QName PROP_NAME_SERVICE_EPR = new QName("remoteServiceUrl");
    private static final QName PROP_NAME_USER = new QName("remoteServiceUserName");
    private static final QName PROP_NAME_PASSWORD = new QName("remoteServicePassword");
    private static final QName PROP_NAME_SERVICE_EPR_KEY = new QName("remoteServiceUrlKey");
    private static final QName PROP_NAME_USER_KEY = new QName("remoteServiceUserNameKey");
    private static final QName PROP_NAME_PASSWORD_KEY = new QName("remoteServicePasswordKey");
    private static final QName PROP_NAME_CALLBACK_CLASS = new QName("callbackClass");
    private static final QName PROP_NAME_THRIFT_HOST = new QName("thriftHost");
    private static final QName PROP_NAME_THRIFT_PORT = new QName("thriftPort");
    private static final QName PROP_NAME_CLIENT_CLASS = new QName("client");
    private static final String ADVICE = "advice";
    private static final String OBLIGATIONS = "obligations";
    private String onRejectSeqKey = null;
    private String onAcceptSeqKey = null;
    private String adviceSeqKey = null;
    private String obligationsSeqKey = null;

    public EntitlementMediator() {
        this.addChild((Mediator)new OnAcceptMediator());
        this.addChild((Mediator)new OnRejectMediator());
        this.addChild((Mediator)new ObligationsMediator());
        this.addChild((Mediator)new AdviceMediator());
    }

    public OMElement serialize(OMElement parent) {
        OMElement entitlementService = fac.createOMElement("entitlementService", synNS);
        if (this.remoteServiceUrl != null && this.remoteServiceUrl.trim().length() != 0) {
            entitlementService.addAttribute(fac.createOMAttribute("remoteServiceUrl", nullNS, this.remoteServiceUrl));
        } else if (this.remoteServiceUrlKey != null && this.remoteServiceUrlKey.trim().length() != 0) {
            entitlementService.addAttribute(fac.createOMAttribute("remoteServiceUrlKey", nullNS, this.remoteServiceUrlKey));
        } else {
            throw new MediatorException("Invalid Entitlement mediator.Entitlement service epr required");
        }
        if (this.remoteServiceUserName != null && this.remoteServiceUserName.trim().length() != 0) {
            entitlementService.addAttribute(fac.createOMAttribute("remoteServiceUserName", nullNS, this.remoteServiceUserName));
        } else if (this.remoteServiceUserNameKey != null && this.remoteServiceUserNameKey.trim().length() != 0) {
            entitlementService.addAttribute(fac.createOMAttribute("remoteServiceUserNameKey", nullNS, this.remoteServiceUserNameKey));
        } else {
            throw new MediatorException("Invalid Entitlement mediator. Remote service user name required");
        }
        if (this.remoteServicePassword != null && this.remoteServicePassword.trim().length() != 0) {
            entitlementService.addAttribute(fac.createOMAttribute("remoteServicePassword", nullNS, this.remoteServicePassword));
        } else if (this.remoteServicePasswordKey != null && this.remoteServicePasswordKey.trim().length() != 0) {
            entitlementService.addAttribute(fac.createOMAttribute("remoteServicePasswordKey", nullNS, this.remoteServicePasswordKey));
        } else {
            throw new MediatorException("Invalid Entitlement mediator. Remote service password required");
        }
        if (this.callbackClass != null && !"".equalsIgnoreCase(this.callbackClass)) {
            entitlementService.addAttribute(fac.createOMAttribute("callbackClass", nullNS, this.callbackClass));
        }
        if (this.client != null && !"".equalsIgnoreCase(this.client)) {
            entitlementService.addAttribute(fac.createOMAttribute("client", nullNS, this.client));
        }
        if (this.thriftHost != null && !"".equalsIgnoreCase(this.thriftHost)) {
            entitlementService.addAttribute(fac.createOMAttribute("thriftHost", nullNS, this.thriftHost));
        }
        if (this.thriftPort != null && !"".equalsIgnoreCase(this.thriftPort)) {
            entitlementService.addAttribute(fac.createOMAttribute("thriftPort", nullNS, this.thriftPort));
        }
        if (this.onRejectSeqKey != null) {
            entitlementService.addAttribute(fac.createOMAttribute("onReject", nullNS, this.onRejectSeqKey));
        } else {
            for (Mediator m : this.getList()) {
                if (!(m instanceof OnRejectMediator)) continue;
                m.serialize(entitlementService);
            }
        }
        if (this.onAcceptSeqKey != null) {
            entitlementService.addAttribute(fac.createOMAttribute("onAccept", nullNS, this.onAcceptSeqKey));
        } else {
            for (Mediator m : this.getList()) {
                if (!(m instanceof OnAcceptMediator)) continue;
                m.serialize(entitlementService);
            }
        }
        if (this.adviceSeqKey != null) {
            entitlementService.addAttribute(fac.createOMAttribute(ADVICE, nullNS, this.adviceSeqKey));
        } else {
            for (Mediator m : this.getList()) {
                if (!(m instanceof AdviceMediator)) continue;
                m.serialize(entitlementService);
            }
        }
        if (this.obligationsSeqKey != null) {
            entitlementService.addAttribute(fac.createOMAttribute(OBLIGATIONS, nullNS, this.obligationsSeqKey));
        } else {
            for (Mediator m : this.getList()) {
                if (!(m instanceof ObligationsMediator)) continue;
                m.serialize(entitlementService);
            }
        }
        EntitlementMediator.saveTracingState((OMElement)entitlementService, (Mediator)this);
        if (parent != null) {
            parent.addChild((OMNode)entitlementService);
        }
        return entitlementService;
    }

    public void build(OMElement elem) {
        OMAttribute onReject;
        this.getList().clear();
        OMAttribute attRemoteServiceUri = elem.getAttribute(PROP_NAME_SERVICE_EPR);
        OMAttribute attRemoteServiceUserName = elem.getAttribute(PROP_NAME_USER);
        OMAttribute attRemoteServicePassword = elem.getAttribute(PROP_NAME_PASSWORD);
        OMAttribute attRemoteServiceUriKey = elem.getAttribute(PROP_NAME_SERVICE_EPR_KEY);
        OMAttribute attRemoteServiceUserNameKey = elem.getAttribute(PROP_NAME_USER_KEY);
        OMAttribute attRemoteServicePasswordKey = elem.getAttribute(PROP_NAME_PASSWORD_KEY);
        OMAttribute attCallbackClass = elem.getAttribute(PROP_NAME_CALLBACK_CLASS);
        OMAttribute attThriftHost = elem.getAttribute(PROP_NAME_THRIFT_HOST);
        OMAttribute attThriftPort = elem.getAttribute(PROP_NAME_THRIFT_PORT);
        OMAttribute attClient = elem.getAttribute(PROP_NAME_CLIENT_CLASS);
        this.onAcceptSeqKey = null;
        this.onRejectSeqKey = null;
        this.adviceSeqKey = null;
        this.obligationsSeqKey = null;
        if (attRemoteServiceUri != null) {
            this.remoteServiceUrl = attRemoteServiceUri.getAttributeValue();
        } else if (attRemoteServiceUriKey != null) {
            this.setRemoteServiceUrlKey(attRemoteServiceUriKey.getAttributeValue());
        } else {
            throw new MediatorException("The 'remoteServiceUrl' attribute is required for the Entitlement mediator");
        }
        if (attRemoteServiceUserName != null) {
            this.remoteServiceUserName = attRemoteServiceUserName.getAttributeValue();
        } else if (attRemoteServiceUserNameKey != null) {
            this.setRemoteServiceUserNameKey(attRemoteServiceUserNameKey.getAttributeValue());
        } else {
            throw new MediatorException("The 'remoteServiceUserName' attribute is required for the Entitlement mediator");
        }
        if (attRemoteServicePassword != null) {
            this.remoteServicePassword = attRemoteServicePassword.getAttributeValue();
        } else if (attRemoteServicePasswordKey != null) {
            this.setRemoteServicePasswordKey(attRemoteServicePasswordKey.getAttributeValue());
        } else {
            throw new MediatorException("The 'remoteServicePassword' attribute is required for the Entitlement mediator");
        }
        if (attCallbackClass != null) {
            this.callbackClass = attCallbackClass.getAttributeValue();
        }
        if (attClient != null) {
            this.client = attClient.getAttributeValue();
        }
        if (attThriftHost != null) {
            this.thriftHost = attThriftHost.getAttributeValue();
        }
        if (attThriftPort != null) {
            this.thriftPort = attThriftPort.getAttributeValue();
        }
        if ((onReject = elem.getAttribute(new QName("", "onReject"))) != null) {
            String onRejectValue = onReject.getAttributeValue();
            if (onRejectValue != null) {
                this.onRejectSeqKey = onRejectValue.trim();
            }
        } else {
            OMElement onRejectMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onReject"));
            if (onRejectMediatorElement != null) {
                OnRejectMediator onRejectMediator = new OnRejectMediator();
                onRejectMediator.build(onRejectMediatorElement);
                this.addChild((Mediator)onRejectMediator);
            }
        }
        OMAttribute onAccept = elem.getAttribute(new QName("", "onAccept"));
        if (onAccept != null) {
            String onAcceptValue = onAccept.getAttributeValue();
            if (onAcceptValue != null) {
                this.onAcceptSeqKey = onAcceptValue;
            }
        } else {
            OMElement onAcceptMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "onAccept"));
            if (onAcceptMediatorElement != null) {
                OnAcceptMediator onAcceptMediator = new OnAcceptMediator();
                onAcceptMediator.build(onAcceptMediatorElement);
                this.addChild((Mediator)onAcceptMediator);
            }
        }
        OMAttribute advice = elem.getAttribute(new QName("", ADVICE));
        if (advice != null) {
            String adviceValue = advice.getAttributeValue();
            if (adviceValue != null) {
                this.adviceSeqKey = adviceValue;
            }
        } else {
            OMElement adviceMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", ADVICE));
            if (adviceMediatorElement != null) {
                AdviceMediator adviceMediator = new AdviceMediator();
                adviceMediator.build(adviceMediatorElement);
                this.addChild((Mediator)adviceMediator);
            }
        }
        OMAttribute obligations = elem.getAttribute(new QName("", OBLIGATIONS));
        if (obligations != null) {
            String obligationsValue = obligations.getAttributeValue();
            if (obligationsValue != null) {
                this.onAcceptSeqKey = obligationsValue;
            }
        } else {
            OMElement obligationsMediatorElement = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", OBLIGATIONS));
            if (obligationsMediatorElement != null) {
                ObligationsMediator obligationsMediator = new ObligationsMediator();
                obligationsMediator.build(obligationsMediatorElement);
                this.addChild((Mediator)obligationsMediator);
            }
        }
    }

    public String getRemoteServiceUserName() {
        return this.remoteServiceUserName;
    }

    public void setRemoteServiceUserName(String remoteServiceUserName) {
        this.remoteServiceUserName = remoteServiceUserName;
    }

    public String getRemoteServicePassword() {
        return this.remoteServicePassword;
    }

    public void setRemoteServicePassword(String remoteServicePassword) {
        this.remoteServicePassword = remoteServicePassword;
    }

    public String getRemoteServiceUrl() {
        return this.remoteServiceUrl;
    }

    public void setRemoteServiceUrl(String remoteServiceUrl) {
        this.remoteServiceUrl = remoteServiceUrl;
    }

    public String getCallbackClass() {
        return this.callbackClass;
    }

    public void setCallbackClass(String callbackClass) {
        this.callbackClass = callbackClass;
    }

    public String getThriftHost() {
        return this.thriftHost;
    }

    public void setThriftHost(String thriftHost) {
        this.thriftHost = thriftHost;
    }

    public String getThriftPort() {
        return this.thriftPort;
    }

    public void setThriftPort(String thriftPort) {
        this.thriftPort = thriftPort;
    }

    public String getClient() {
        return this.client;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getOnRejectSeqKey() {
        return this.onRejectSeqKey;
    }

    public void setOnRejectSeqKey(String onRejectSeqKey) {
        this.onRejectSeqKey = onRejectSeqKey;
    }

    public String getOnAcceptSeqKey() {
        return this.onAcceptSeqKey;
    }

    public void setOnAcceptSeqKey(String onAcceptSeqKey) {
        this.onAcceptSeqKey = onAcceptSeqKey;
    }

    public String getAdviceSeqKey() {
        return this.adviceSeqKey;
    }

    public void setAdviceSeqKey(String adviceSeqKey) {
        this.adviceSeqKey = adviceSeqKey;
    }

    public String getObligationsSeqKey() {
        return this.obligationsSeqKey;
    }

    public void setObligationsSeqKey(String obligationsSeqKey) {
        this.obligationsSeqKey = obligationsSeqKey;
    }

    public String getRemoteServiceUserNameKey() {
        return this.remoteServiceUserNameKey;
    }

    public void setRemoteServiceUserNameKey(String remoteServiceUserNameKey) {
        this.remoteServiceUserNameKey = remoteServiceUserNameKey;
    }

    public String getRemoteServicePasswordKey() {
        return this.remoteServicePasswordKey;
    }

    public void setRemoteServicePasswordKey(String remoteServicePasswordKey) {
        this.remoteServicePasswordKey = remoteServicePasswordKey;
    }

    public String getRemoteServiceUrlKey() {
        return this.remoteServiceUrlKey;
    }

    public void setRemoteServiceUrlKey(String remoteServiceUrlKey) {
        this.remoteServiceUrlKey = remoteServiceUrlKey;
    }

    public String getTagLocalName() {
        return "entitlementService";
    }
}

