/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.event;

import org.apache.axiom.om.OMElement;
import org.apache.axis2.context.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.ws.internal.exception.WSEventException;
import org.wso2.carbon.event.ws.internal.util.EventBrokerUtils;

public class EventMediator
extends AbstractMediator {
    private Value topic = null;
    private SynapseXPath expression = null;

    public boolean mediate(org.apache.synapse.MessageContext synCtx) {
        MessageContext mc;
        if (synCtx.getEnvironment().isDebuggerEnabled() && super.divertMediationRoute(synCtx)) {
            return true;
        }
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Event mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        String topicValue = null;
        if (this.topic != null) {
            topicValue = this.topic.evaluateValue(synCtx);
        } else {
            mc = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            try {
                topicValue = EventBrokerUtils.extractTopicFromMessage((MessageContext)mc);
            }
            catch (WSEventException e) {
                this.handleException("Error extracting the topic from the message", (Exception)((Object)e), synCtx);
            }
        }
        if (topicValue == null) {
            this.handleException("Topic for the event cannot be found", synCtx);
        } else {
            mc = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
            EventBroker broker = (EventBroker)mc.getConfigurationContext().getProperty("mediation.event.broker");
            if (broker == null) {
                this.handleException("EventBroker cannot be found", synCtx);
            } else {
                Message message = new Message();
                if (this.expression == null) {
                    message.setMessage(synCtx.getEnvelope().getBody().getFirstElement());
                } else {
                    try {
                        Object o = this.expression.selectSingleNode((Object)synCtx);
                        if (o instanceof OMElement) {
                            message.setMessage((OMElement)o);
                        } else {
                            this.handleException("The result of the expression:" + this.expression + " should be an OMElement", synCtx);
                        }
                    }
                    catch (JaxenException e) {
                        this.handleException("Error evaluating the expression: " + this.expression, synCtx);
                    }
                }
                try {
                    broker.publish(message, topicValue);
                }
                catch (EventBrokerException e) {
                    this.handleException("Error publishing the event to the broker", (Exception)((Object)e), synCtx);
                }
                catch (Exception e) {
                    this.log.error((Object)"Error in setting tenant information", (Throwable)e);
                }
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"End : Event mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        return true;
    }

    public Value getTopic() {
        return this.topic;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public void setTopic(Value topic) {
        this.topic = topic;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }
}

