/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.log;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.carbon.mediator.service.ui.AbstractMediator;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.service.util.MediatorProperty;

public class LogMediator
extends AbstractMediator {
    public static final int CUSTOM_VALUE = 0;
    public static final int SIMPLE_VALUE = 1;
    public static final int HEADERS_VALUE = 2;
    public static final int FULL_VALUE = 3;
    private static final String SIMPLE = "simple";
    private static final String HEADERS = "headers";
    private static final String FULL = "full";
    private static final String CUSTOM = "custom";
    private static final QName ATT_LEVEL = new QName("level");
    private static final QName ATT_SEPERATOR = new QName("separator");
    private static final QName ATT_CATEGORY = new QName("category");
    private static final String TRACE = "TRACE";
    private static final String DEBUG = "DEBUG";
    private static final String INFO = "INFO";
    private static final String WARN = "WARN";
    private static final String ERROR = "ERROR";
    private static final String FATAL = "FATAL";
    public static final int TRACE_VALUE = 0;
    public static final int DEBUG_VALUE = 1;
    public static final int INFO_VALUE = 2;
    public static final int WARN_VALUE = 3;
    public static final int ERROR_VALUE = 4;
    public static final int FATAL_VALUE = 5;
    public static final String DEFAULT_SEP = ", ";
    private int logLevel = 1;
    private int logCategory = 2;
    private String separator = ", ";
    private final List<MediatorProperty> properties = new ArrayList<MediatorProperty>();

    public String getTagLocalName() {
        return "log";
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getSeparator() {
        return this.separator.replace("\n", "\\n").replace("\t", "\\t");
    }

    public int getLogCategory() {
        return this.logCategory;
    }

    public void setLogCategory(int logCategory) {
        this.logCategory = logCategory;
    }

    public List<MediatorProperty> getProperties() {
        return this.properties;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    public void setSeparator(String separator) {
        this.separator = separator.replace("\\n", "\n").replace("\\t", "\t");
    }

    public void addProperty(MediatorProperty p) {
        this.properties.add(p);
    }

    public void addAllProperties(List<MediatorProperty> list) {
        this.properties.addAll(list);
    }

    public OMElement serialize(OMElement parent) {
        OMElement log = fac.createOMElement("log", synNS);
        LogMediator.saveTracingState((OMElement)log, (Mediator)this);
        if (this.logLevel != 1) {
            log.addAttribute(fac.createOMAttribute("level", nullNS, this.logLevel == 2 ? HEADERS : (this.logLevel == 3 ? FULL : (this.logLevel == 0 ? CUSTOM : SIMPLE))));
        }
        if (this.logCategory != 2) {
            log.addAttribute(fac.createOMAttribute("category", nullNS, this.logCategory == 0 ? TRACE : (this.logCategory == 1 ? DEBUG : (this.logCategory == 3 ? WARN : (this.logCategory == 4 ? ERROR : (this.logCategory == 5 ? FATAL : INFO))))));
        }
        if (!DEFAULT_SEP.equals(this.separator)) {
            log.addAttribute(fac.createOMAttribute("separator", nullNS, this.separator));
        }
        this.serializeMediatorProperties(log, this.properties, PROP_Q);
        if (parent != null) {
            parent.addChild((OMNode)log);
        }
        return log;
    }

    public void build(OMElement elem) {
        OMAttribute separator;
        OMAttribute category;
        this.processAuditStatus((Mediator)this, elem);
        OMAttribute level = elem.getAttribute(ATT_LEVEL);
        if (level != null) {
            String levelstr = level.getAttributeValue();
            if (SIMPLE.equals(levelstr)) {
                this.logLevel = 1;
            } else if (HEADERS.equals(levelstr)) {
                this.logLevel = 2;
            } else if (FULL.equals(levelstr)) {
                this.logLevel = 3;
            } else if (CUSTOM.equals(levelstr)) {
                this.logLevel = 0;
            }
        }
        if ((category = elem.getAttribute(ATT_CATEGORY)) != null) {
            String categoryStr = category.getAttributeValue();
            if (TRACE.equals(categoryStr)) {
                this.logCategory = 0;
            } else if (DEBUG.equals(categoryStr)) {
                this.logCategory = 1;
            } else if (INFO.equals(categoryStr)) {
                this.logCategory = 2;
            } else if (WARN.equals(categoryStr)) {
                this.logCategory = 3;
            } else if (ERROR.equals(categoryStr)) {
                this.logCategory = 4;
            } else if (FATAL.equals(categoryStr)) {
                this.logCategory = 5;
            }
        }
        if ((separator = elem.getAttribute(ATT_SEPERATOR)) != null) {
            this.setSeparator(separator.getAttributeValue());
        }
        this.addAllProperties(LogMediator.getMediatorProperties((OMElement)elem));
    }
}

