/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.service.builtin;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.config.xml.ValueFactory;
import org.apache.synapse.config.xml.ValueSerializer;
import org.apache.synapse.mediators.Value;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.AbstractListMediator;

public class SequenceMediator
extends AbstractListMediator {
    private Value key;
    private String name;
    private String errorHandler;
    private String description;
    private boolean anonymous = false;

    public String getName() {
        return this.name;
    }

    public String getErrorHandler() {
        return this.errorHandler;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setErrorHandler(String errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Value getKey() {
        return this.key;
    }

    public void setKey(Value key) {
        this.key = key;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getTagLocalName() {
        return "sequence";
    }

    public void setAnonymous(boolean anonymous) {
        this.anonymous = anonymous;
    }

    public boolean isAnonymous() {
        return this.anonymous;
    }

    @Override
    public OMElement serialize(OMElement parent) {
        OMElement sequence = fac.createOMElement("sequence", synNS);
        if (!this.anonymous) {
            if (this.key != null) {
                ValueSerializer keySerializer = new ValueSerializer();
                keySerializer.serializeValue(this.key, "key", sequence);
            } else if (this.name != null) {
                sequence.addAttribute(fac.createOMAttribute("name", nullNS, this.name));
                if (this.errorHandler != null) {
                    sequence.addAttribute(fac.createOMAttribute("onError", nullNS, this.errorHandler));
                }
                SequenceMediator.saveTracingState(sequence, this);
                this.serializeChildren(sequence, this.getList());
            }
            if (parent != null) {
                parent.addChild((OMNode)sequence);
            }
        } else {
            if (this.errorHandler != null) {
                sequence.addAttribute(fac.createOMAttribute("onError", nullNS, this.errorHandler));
            }
            SequenceMediator.saveTracingState(sequence, this);
            this.serializeChildren(sequence, this.getList());
            if (parent != null) {
                parent.addChild((OMNode)sequence);
            }
        }
        if (this.description != null) {
            OMElement descriptionElem = sequence.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "description"));
            if (descriptionElem != null) {
                descriptionElem.setText(this.description);
            } else {
                OMElement newDescriptionElem = fac.createOMElement("description", synNS);
                newDescriptionElem.setText(this.description);
                sequence.addChild((OMNode)newDescriptionElem);
            }
        }
        return sequence;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void build(OMElement elem) {
        this.key = null;
        this.name = null;
        this.errorHandler = null;
        OMAttribute n = elem.getAttribute(ATT_NAME);
        OMAttribute e = elem.getAttribute(ATT_ONERROR);
        OMElement descriptionElem = elem.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "description"));
        if (descriptionElem != null && descriptionElem.getText() != null) {
            this.description = descriptionElem.getText();
        }
        if (!this.anonymous) {
            if (n != null) {
                this.name = n.getAttributeValue();
                if (e != null) {
                    this.errorHandler = e.getAttributeValue();
                }
                this.processAuditStatus(this, elem);
                this.addChildren(elem, this);
                return;
            }
            n = elem.getAttribute(ATT_KEY);
            if (n != null) {
                ValueFactory keyFactory = new ValueFactory();
                this.key = keyFactory.createValue("key", elem);
                if (e == null) return;
                String msg = "A sequence mediator with a reference to another sequence can not have 'ErrorHandler'";
                throw new MediatorException(msg);
            }
            String msg = "A sequence mediator should be a named sequence or a reference to another sequence (i.e. a name attribute or key attribute is required)";
            throw new MediatorException(msg);
        }
        if (e != null) {
            this.errorHandler = e.getAttributeValue();
        }
        this.processAuditStatus(this, elem);
        this.addChildren(elem, this);
    }
}

