/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.service.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.xpath.AXIOMXPath;
import org.apache.synapse.SynapseConstants;
import org.apache.synapse.config.xml.SynapsePath;
import org.apache.synapse.config.xml.SynapsePathFactory;
import org.apache.synapse.config.xml.SynapsePathSerializer;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.service.MediatorException;
import org.wso2.carbon.mediator.service.ui.Mediator;
import org.wso2.carbon.mediator.service.util.MediatorProperty;

public abstract class AbstractMediator
implements Mediator {
    private int traceState = 2;
    boolean statEnabled = false;
    private boolean isAuditConfigurable = false;
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace synNS = SynapseConstants.SYNAPSE_OMNAMESPACE;
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");
    protected static final QName ATT_NAME = new QName("name");
    protected static final QName ATT_VALUE = new QName("value");
    protected static final QName ATT_XPATH = new QName("xpath");
    protected static final QName ATT_REGEX = new QName("regex");
    protected static final QName ATT_SEQUENCE = new QName("sequence");
    protected static final QName ATT_EXPRN = new QName("expression");
    protected static final QName ATT_KEY = new QName("key");
    protected static final QName ATT_SOURCE = new QName("source");
    protected static final QName ATT_TARGET = new QName("target");
    protected static final QName ATT_ONERROR = new QName("onError");
    protected static final QName ATT_STATS = new QName("statistics");
    protected static final QName PROP_Q = new QName("http://ws.apache.org/ns/synapse", "property");
    protected static final QName FEATURE_Q = new QName("http://ws.apache.org/ns/synapse", "feature");
    protected static final QName TARGET_Q = new QName("http://ws.apache.org/ns/synapse", "target");

    @Override
    public boolean isAuditConfigurable() {
        return this.isAuditConfigurable;
    }

    protected static void saveTracingState(OMElement mediatorOmElement, Mediator mediator) {
        int traceState = mediator.getTraceState();
        String traceValue = null;
        if (traceState == 1) {
            traceValue = "enable";
        } else if (traceState == 0) {
            traceValue = "disable";
        }
        if (traceValue != null) {
            mediatorOmElement.addAttribute(fac.createOMAttribute("trace", nullNS, traceValue));
        }
        if (mediator.isAuditConfigurable() && mediator.isStatisticsEnable()) {
            mediatorOmElement.addAttribute(fac.createOMAttribute("statistics", nullNS, "enable"));
        }
    }

    protected void serializeMediatorProperties(OMElement parent, Collection<MediatorProperty> props, QName childElementName) {
        for (MediatorProperty mp : props) {
            OMElement prop = fac.createOMElement(childElementName, (OMContainer)parent);
            if (mp.getName() == null) {
                throw new MediatorException("Mediator property name missing");
            }
            prop.addAttribute(fac.createOMAttribute("name", nullNS, mp.getName()));
            if (mp.getValue() != null) {
                prop.addAttribute(fac.createOMAttribute("value", nullNS, mp.getValue()));
                continue;
            }
            if (mp.getExpression() != null) {
                SynapseXPathSerializer.serializeXPath((SynapseXPath)mp.getExpression(), (OMElement)prop, (String)"expression");
                continue;
            }
            if (mp.getPathExpression() != null) {
                SynapsePathSerializer.serializePath((SynapsePath)mp.getPathExpression(), (OMElement)prop, (String)"expression");
                continue;
            }
            throw new MediatorException("Mediator property must have a literal value or be an expression");
        }
    }

    public static List<MediatorProperty> getMediatorProperties(OMElement elem) {
        ArrayList<MediatorProperty> propertyList = new ArrayList<MediatorProperty>();
        Iterator itr = elem.getChildrenWithName(MediatorProperty.PROPERTY_Q);
        while (itr.hasNext()) {
            OMElement propEle = (OMElement)itr.next();
            OMAttribute attName = propEle.getAttribute(MediatorProperty.ATT_NAME_Q);
            OMAttribute attValue = propEle.getAttribute(MediatorProperty.ATT_VALUE_Q);
            OMAttribute attExpr = propEle.getAttribute(MediatorProperty.ATT_EXPR_Q);
            MediatorProperty prop = new MediatorProperty();
            if (attName == null || attName.getAttributeValue() == null || attName.getAttributeValue().trim().length() == 0) {
                String msg = "Entry name is a required attribute for a Log property";
                throw new MediatorException(msg);
            }
            prop.setName(attName.getAttributeValue());
            if (attValue != null) {
                if (attValue.getAttributeValue() == null || attValue.getAttributeValue().trim().length() == 0) {
                    String msg = "Entry attribute value (if specified) is required for a Log property";
                    throw new MediatorException(msg);
                }
                prop.setValue(attValue.getAttributeValue());
            } else if (attExpr != null) {
                if (attExpr.getAttributeValue() == null || attExpr.getAttributeValue().trim().length() == 0) {
                    String msg = "Entry attribute expression (if specified) is required for a mediator property";
                    throw new MediatorException(msg);
                }
                try {
                    if (attExpr.getAttributeValue().startsWith("json-eval(")) {
                        prop.setPathExpression(SynapsePathFactory.getSynapsePath((OMElement)propEle, (QName)MediatorProperty.ATT_EXPR_Q));
                    }
                    prop.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)propEle, (QName)MediatorProperty.ATT_EXPR_Q));
                }
                catch (JaxenException e) {
                    String msg = "Invalid XPapth expression : " + attExpr.getAttributeValue();
                    throw new MediatorException(msg);
                }
            } else {
                String msg = "Entry attribute value OR expression must be specified for a mediator property";
                throw new MediatorException(msg);
            }
            propertyList.add(prop);
        }
        return propertyList;
    }

    protected void serializeNamespaces(OMElement elem, AXIOMXPath xpath) {
        for (Object obj : xpath.getNamespaces().keySet()) {
            String prefix = (String)obj;
            String uri = xpath.getNamespaceContext().translateNamespacePrefixToUri(prefix);
            if ("http://ws.apache.org/ns/synapse".equals(uri)) continue;
            elem.declareNamespace(uri, prefix);
        }
    }

    protected void processAuditStatus(Mediator mediator, OMElement mediatorOmElement) {
        String statisticsValue;
        OMAttribute statistics;
        String traceValue;
        OMAttribute trace = mediatorOmElement.getAttribute(new QName("", "trace"));
        if (trace != null && (traceValue = trace.getAttributeValue()) != null) {
            if (traceValue.equals("enable")) {
                mediator.setTraceState(1);
            } else if (traceValue.equals("disable")) {
                mediator.setTraceState(0);
            }
        }
        if ((statistics = mediatorOmElement.getAttribute(ATT_STATS)) != null && (statisticsValue = statistics.getAttributeValue()) != null && mediator.isAuditConfigurable() && "enable".equals(statisticsValue)) {
            mediator.enableStatistics();
        }
    }

    protected Map<String, String> collectNameValuePairs(OMElement elem, QName childElementName) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Iterator it = elem.getChildrenWithName(childElementName);
        while (it.hasNext()) {
            OMElement child = (OMElement)it.next();
            OMAttribute attName = child.getAttribute(ATT_NAME);
            OMAttribute attValue = child.getAttribute(ATT_VALUE);
            if (attName != null && attValue != null) {
                String name = attName.getAttributeValue().trim();
                String value = attValue.getAttributeValue().trim();
                if (result.containsKey(name)) {
                    throw new MediatorException("Duplicate " + childElementName.getLocalPart() + " with name " + name);
                }
                result.put(name, value);
                continue;
            }
            throw new MediatorException("Both of the name and value attributes are required for a " + childElementName.getLocalPart());
        }
        return result;
    }

    @Override
    public int getTraceState() {
        return this.traceState;
    }

    @Override
    public void setTraceState(int traceState) {
        this.traceState = traceState;
    }

    @Override
    public boolean isStatisticsEnable() {
        return this.statEnabled;
    }

    @Override
    public void disableStatistics() {
        this.statEnabled = false;
    }

    @Override
    public void enableStatistics() {
        this.statEnabled = true;
    }

    public void setAuditConfigurable(boolean auditConfigurable) {
        this.isAuditConfigurable = auditConfigurable;
    }
}

