/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.util.PayloadHelper;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.transform.SmooksMediator;
import org.wso2.carbon.mediator.transform.stream.ElementInputStream;
import org.wso2.carbon.mediator.transform.stream.IOElementPipe;

public class Input {
    private SmooksMediator.TYPES type = SmooksMediator.TYPES.XML;
    private SynapseXPath expression = null;

    public StreamSource process(MessageContext synCtx, SynapseLog synLog) {
        block16: {
            if (this.expression != null) {
                try {
                    List selectedNodeList = this.expression.selectNodes((Object)synCtx);
                    if (selectedNodeList != null && selectedNodeList.size() != 0) {
                        OMNode node = (OMNode)selectedNodeList.get(0);
                        if (node instanceof OMElement) {
                            IOElementPipe pipe = new IOElementPipe((OMElement)node);
                            ElementInputStream inputStream = new ElementInputStream(pipe);
                            return new StreamSource(inputStream);
                        }
                        if (node instanceof OMText) {
                            return new StreamSource(new ByteArrayInputStream(((OMText)node).getText().getBytes()));
                        }
                        break block16;
                    }
                    synLog.error((Object)"Specified node by xpath cannot be found.");
                }
                catch (JaxenException e) {
                    this.handleException("Error evaluating the Expression", synLog);
                }
                catch (XMLStreamException e) {
                    this.handleException("Error serializing the input", synLog);
                }
                catch (FactoryConfigurationError e) {
                    this.handleException("Failed to load XMLInputFactory instance", synLog);
                }
            } else if (this.type == SmooksMediator.TYPES.TEXT) {
                OMElement element = PayloadHelper.getXMLPayload((SOAPEnvelope)synCtx.getEnvelope());
                if (element != null) {
                    return new StreamSource(ElementHelper.getTextAsStream((OMElement)element, (boolean)false));
                }
            } else if (this.type == SmooksMediator.TYPES.XML) {
                IOElementPipe pipe = null;
                try {
                    pipe = new IOElementPipe(PayloadHelper.getXMLPayload((SOAPEnvelope)synCtx.getEnvelope()));
                }
                catch (XMLStreamException e) {
                    this.handleException("Error initializing IOElementPipe object", synLog);
                }
                catch (FactoryConfigurationError e) {
                    this.handleException("Failed to load XMLInputFactory instance", synLog);
                }
                ElementInputStream inputStream = new ElementInputStream(pipe);
                return new StreamSource(inputStream);
            }
        }
        return null;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }

    public SmooksMediator.TYPES getType() {
        return this.type;
    }

    public void setType(SmooksMediator.TYPES type) {
        this.type = type;
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    private void handleException(String message, SynapseLog log) {
        log.error((Object)message);
        throw new SynapseException(message);
    }
}

