/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform.xml;

import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.apache.synapse.config.xml.SynapseXPathFactory;
import org.jaxen.JaxenException;
import org.wso2.carbon.mediator.transform.Input;
import org.wso2.carbon.mediator.transform.Output;
import org.wso2.carbon.mediator.transform.SmooksMediator;

public class SmooksMediatorFactory
extends AbstractMediatorFactory {
    public static final QName SMOOKS_Q = new QName("http://ws.apache.org/ns/synapse", "smooks");
    public static final QName CONFIG_KEY = new QName("config-key");
    public static final QName PERSISTENCE_UNIT = new QName("persistence-unit");

    public Mediator createSpecificMediator(OMElement omElement, Properties properties) {
        OMElement inputElement;
        OMAttribute persistenceUnitAttr;
        SmooksMediator smooks = new SmooksMediator();
        OMAttribute configFileAttr = omElement.getAttribute(CONFIG_KEY);
        if (configFileAttr != null) {
            smooks.setConfigKey(configFileAttr.getAttributeValue());
        }
        if ((persistenceUnitAttr = omElement.getAttribute(PERSISTENCE_UNIT)) != null) {
            smooks.setPersistenceUnitAttr(persistenceUnitAttr.getAttributeValue());
        }
        if ((inputElement = omElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "input"))) != null) {
            smooks.setInput(this.createInput(inputElement));
        } else {
            smooks.setInput(new Input());
        }
        OMElement outputElement = omElement.getFirstChildWithName(new QName("http://ws.apache.org/ns/synapse", "output"));
        if (inputElement != null) {
            smooks.setOutput(this.createOutput(outputElement));
        } else {
            smooks.setOutput(new Output());
        }
        SmooksMediatorFactory.addAllCommentChildrenToList((OMElement)omElement, (List)smooks.getCommentsList());
        return smooks;
    }

    private Input createInput(OMElement input) {
        Input in = new Input();
        OMAttribute typeAttr = input.getAttribute(new QName("type"));
        if (typeAttr == null) {
            this.handleException("type attribute is required for the input element");
        }
        assert (typeAttr != null);
        String typeValue = typeAttr.getAttributeValue();
        if (typeValue.equals("text")) {
            in.setType(SmooksMediator.TYPES.TEXT);
        } else if (typeValue.equals("xml")) {
            in.setType(SmooksMediator.TYPES.XML);
        } else {
            this.handleException("Unexpected type specified as the input: " + typeValue);
        }
        if (input.getAttribute(new QName("expression")) != null) {
            try {
                in.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)input, (QName)new QName("expression")));
            }
            catch (JaxenException e) {
                this.handleException("Error creating the XPath expression", (Exception)((Object)e));
            }
        }
        return in;
    }

    private Output createOutput(OMElement output) {
        OMAttribute propertyAttr;
        OMAttribute actionAttr;
        Output in = new Output();
        OMAttribute typeAttr = output.getAttribute(new QName("type"));
        if (typeAttr == null) {
            this.handleException("type attribute is required for the input element");
        }
        assert (typeAttr != null);
        String typeValue = typeAttr.getAttributeValue();
        if (typeValue.equals("text")) {
            in.setType(SmooksMediator.TYPES.TEXT);
        } else if (typeValue.equals("xml")) {
            in.setType(SmooksMediator.TYPES.XML);
        } else if (typeValue.equals("java")) {
            in.setType(SmooksMediator.TYPES.JAVA);
        } else {
            this.handleException("Unexpected type specified as the input: " + typeValue);
        }
        if (output.getAttribute(new QName("expression")) != null) {
            try {
                in.setExpression(SynapseXPathFactory.getSynapseXPath((OMElement)output, (QName)new QName("expression")));
            }
            catch (JaxenException e) {
                this.handleException("Error creating the XPath expression", (Exception)((Object)e));
            }
        }
        if ((actionAttr = output.getAttribute(new QName("action"))) != null && actionAttr.getAttributeValue() != null) {
            in.setAction(actionAttr.getAttributeValue());
        }
        if ((propertyAttr = output.getAttribute(new QName("property"))) != null && propertyAttr.getAttributeValue() != null) {
            in.setProperty(propertyAttr.getAttributeValue());
        }
        return in;
    }

    public QName getTagQName() {
        return SMOOKS_Q;
    }
}

