/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform.xml;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorSerializer;
import org.apache.synapse.config.xml.SynapseXPathSerializer;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.wso2.carbon.mediator.transform.Input;
import org.wso2.carbon.mediator.transform.Output;
import org.wso2.carbon.mediator.transform.SmooksMediator;

public class SmooksMediatorSerializer
extends AbstractMediatorSerializer {
    public OMElement serializeSpecificMediator(Mediator mediator) {
        assert (mediator instanceof SmooksMediator) : "Smooks mediator is expected";
        SmooksMediator smooksMediator = (SmooksMediator)mediator;
        OMElement smooks = fac.createOMElement("smooks", synNS);
        smooks.addAttribute(fac.createOMAttribute("config-key", nullNS, smooksMediator.getConfigKey()));
        if (smooksMediator.getPersistenceUnitName() != null) {
            smooks.addAttribute(fac.createOMAttribute("persistence-unit", nullNS, smooksMediator.getPersistenceUnitName()));
        }
        smooks.addChild((OMNode)this.createInput(smooksMediator.getInput()));
        smooks.addChild((OMNode)this.createOutput(smooksMediator.getOutput()));
        this.serializeComments(smooks, smooksMediator.getCommentsList());
        return smooks;
    }

    private OMElement createInput(Input input) {
        OMElement inputElement = fac.createOMElement("input", synNS);
        if (input.getType() == SmooksMediator.TYPES.TEXT) {
            inputElement.addAttribute(fac.createOMAttribute("type", nullNS, "text"));
        } else if (input.getType() == SmooksMediator.TYPES.XML) {
            inputElement.addAttribute(fac.createOMAttribute("type", nullNS, "xml"));
        }
        if (input.getExpression() != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)input.getExpression(), (OMElement)inputElement, (String)"expression");
        }
        return inputElement;
    }

    private OMElement createOutput(Output output) {
        OMElement outputElement = fac.createOMElement("output", synNS);
        if (output.getType() == SmooksMediator.TYPES.TEXT) {
            outputElement.addAttribute(fac.createOMAttribute("type", nullNS, "text"));
        } else if (output.getType() == SmooksMediator.TYPES.XML) {
            outputElement.addAttribute(fac.createOMAttribute("type", nullNS, "xml"));
        } else if (output.getType() == SmooksMediator.TYPES.JAVA) {
            outputElement.addAttribute(fac.createOMAttribute("type", nullNS, "java"));
        }
        if (output.getExpression() != null) {
            SynapseXPathSerializer.serializeXPath((SynapseXPath)output.getExpression(), (OMElement)outputElement, (String)"expression");
        }
        if (output.getProperty() != null) {
            outputElement.addAttribute(fac.createOMAttribute("property", nullNS, output.getProperty()));
        }
        if (output.getAction() != null) {
            outputElement.addAttribute(fac.createOMAttribute("action", nullNS, output.getAction()));
        }
        return outputElement;
    }

    public String getMediatorClassName() {
        return SmooksMediator.class.getName();
    }
}

