/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform.stream;

import java.io.IOException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.XMLEvent;
import org.apache.axiom.om.OMElement;
import org.wso2.carbon.mediator.transform.stream.ElementOutputStream;

public class IOElementPipe {
    private ElementOutputStream outputStream;
    private XMLEventReader eventReader;
    private final int MAX_EVENT_COUNT = 10;
    private XMLEventWriter xmlWriter;

    public IOElementPipe(OMElement element) throws XMLStreamException, FactoryConfigurationError {
        XMLStreamReader xmlReader = element.getXMLStreamReaderWithoutCaching();
        this.eventReader = XMLInputFactory.newInstance().createXMLEventReader(xmlReader);
        this.outputStream = new ElementOutputStream();
        this.xmlWriter = XMLOutputFactory.newInstance().createXMLEventWriter(this.outputStream);
    }

    public final byte[] getData(int count, int off) throws XMLStreamException {
        this.populateEvents();
        byte[] xmlEventsBuffer = this.outputStream.toByteArray();
        if (xmlEventsBuffer.length < count) {
            count = xmlEventsBuffer.length;
        }
        byte[] copiedEventsBuffer = new byte[count];
        System.arraycopy(xmlEventsBuffer, 0, copiedEventsBuffer, off, count);
        this.outputStream.resizeBuffer(count);
        return copiedEventsBuffer;
    }

    private void populateEvents() throws XMLStreamException {
        for (int count = 0; this.eventReader.hasNext() && count < 10; ++count) {
            XMLEvent event = (XMLEvent)this.eventReader.next();
            this.xmlWriter.add(event);
        }
        this.xmlWriter.flush();
    }

    public void closeConnections() throws XMLStreamException, IOException {
        this.eventReader.close();
        this.outputStream.close();
        this.xmlWriter.close();
    }
}

