/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.mediator.transform.stream;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.mediator.transform.stream.IOElementPipe;

public class ElementInputStream
extends InputStream {
    private IOElementPipe pipe;
    private static final Log log = LogFactory.getLog(ElementInputStream.class);

    public ElementInputStream(IOElementPipe pipe) {
        this.pipe = pipe;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException("Null byte array passed to read data");
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException("IndexOutOfBoundException when reading data");
        }
        if (len <= 0) {
            return 0;
        }
        try {
            byte[] btemp = this.pipe.getData(len, off);
            if (len > btemp.length) {
                len = btemp.length;
            }
            if (btemp.length == 0) {
                this.pipe.closeConnections();
                return -1;
            }
            System.arraycopy(btemp, 0, b, off, len);
        }
        catch (XMLStreamException e) {
            String errMessage = "Error in writting xml events";
            log.error((Object)errMessage);
        }
        catch (IOException e) {
            String errMessage = "Error in closing outputstream";
            log.error((Object)errMessage);
        }
        return len;
    }

    @Override
    public int read() throws IOException {
        byte[] buf = new byte[1];
        int count = this.read(buf, 0, 1);
        if (count > 0) {
            return buf[0];
        }
        return -1;
    }
}

