/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.deployment.Deployer;
import org.apache.axis2.deployment.DeploymentEngine;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.ServerContextInformation;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.deployers.MessageStoreDeployer;
import org.apache.synapse.deployers.SynapseArtifactDeploymentStore;
import org.apache.synapse.message.store.MessageStore;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.mediation.dependency.mgt.services.DependencyManagementService;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.services.SynapseConfigurationService;
import org.wso2.carbon.mediation.initializer.services.SynapseEnvironmentService;
import org.wso2.carbon.mediation.initializer.services.SynapseRegistrationsService;
import org.wso2.carbon.message.store.service.MessageStoreDeployerService;
import org.wso2.carbon.message.store.service.MessageStoreDeployerServiceImpl;
import org.wso2.carbon.message.store.util.ConfigHolder;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.service.mgt.ServiceAdmin;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;
import org.wso2.carbon.utils.ConfigurationContextService;

public class MessageStoreAdminServiceComponent
extends AbstractAxis2ConfigurationContextObserver {
    private static Log log = LogFactory.getLog(MessageStoreAdminServiceComponent.class);
    private boolean activated = false;

    protected void activate(ComponentContext ctxt) {
        try {
            BundleContext bndCtx = ctxt.getBundleContext();
            bndCtx.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)this, null);
            bndCtx.registerService(MessageStoreDeployerService.class.getName(), (Object)new MessageStoreDeployerServiceImpl(), null);
            SynapseEnvironmentService synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(-1234);
            this.registerDeployer(ConfigHolder.getInstance().getAxisConfiguration(), synEnvService.getSynapseEnvironment());
            if (log.isDebugEnabled()) {
                log.debug((Object)"Message Store Admin bundle is activated for Super tenant");
            }
            this.activated = true;
        }
        catch (Throwable e) {
            log.error((Object)"Failed to activate Message Store Admin bundle for Super tenant ", e);
        }
    }

    protected void deactivate(ComponentContext context) {
        try {
            Set<Map.Entry<Integer, SynapseEnvironmentService>> entrySet = ConfigHolder.getInstance().getSynapseEnvironmentServices().entrySet();
            for (Map.Entry<Integer, SynapseEnvironmentService> entry : entrySet) {
                this.unregisterDeployer(entry.getValue().getConfigurationContext().getAxisConfiguration(), entry.getValue().getSynapseEnvironment());
            }
        }
        catch (Exception e) {
            log.warn((Object)"Couldn't remove the Message Store Deployer");
        }
    }

    protected void setConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(cfgCtxService.getServerConfigContext().getAxisConfiguration());
    }

    protected void unsetConfigurationContextService(ConfigurationContextService cfgCtxService) {
        ConfigHolder.getInstance().setAxisConfiguration(null);
    }

    protected void setSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(synapseConfigurationService.getSynapseConfiguration());
    }

    protected void unsetSynapseConfigurationService(SynapseConfigurationService synapseConfigurationService) {
        ConfigHolder.getInstance().setSynapseConfiguration(null);
    }

    protected void setSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        boolean alreadyCreated = ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(synapseEnvironmentService.getTenantId());
        ConfigHolder.getInstance().addSynapseEnvironmentService(synapseEnvironmentService.getTenantId(), synapseEnvironmentService);
        if (this.activated && !alreadyCreated) {
            try {
                this.registerDeployer(synapseEnvironmentService.getConfigurationContext().getAxisConfiguration(), synapseEnvironmentService.getSynapseEnvironment());
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Message Store Admin bundle is activated for tenant");
                }
            }
            catch (Throwable e) {
                log.error((Object)"Failed to activate Message Store Admin bundle for tenant ", e);
            }
        }
    }

    protected void unsetSynapseEnvironmentService(SynapseEnvironmentService synapseEnvironmentService) {
        ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseEnvironmentService.getTenantId());
    }

    protected void setRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService bound to the ESB initialization process");
        }
        try {
            ConfigHolder.getInstance().setRegistry(regService.getConfigSystemRegistry());
        }
        catch (RegistryException e) {
            log.error((Object)"Couldn't retrieve the registry from the registry service");
        }
    }

    protected void setSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
    }

    protected void unsetSynapseRegistrationsService(SynapseRegistrationsService synapseRegistrationsService) {
        int tenantId = synapseRegistrationsService.getTenantId();
        if (ConfigHolder.getInstance().getSynapseEnvironmentServices().containsKey(tenantId)) {
            SynapseEnvironment env = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId).getSynapseEnvironment();
            ConfigHolder.getInstance().removeSynapseEnvironmentService(synapseRegistrationsService.getTenantId());
            AxisConfiguration axisConfig = synapseRegistrationsService.getConfigurationContext().getAxisConfiguration();
            if (axisConfig != null) {
                this.unregisterDeployer(axisConfig, env);
            }
        }
    }

    protected void setServiceAdminService(ServiceAdmin service) {
    }

    protected void unsetServiceAdminService(ServiceAdmin service) {
    }

    protected void unsetRegistryService(RegistryService regService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RegistryService unbound from the ESB environment");
        }
        ConfigHolder.getInstance().setRegistry(null);
    }

    protected void setDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service bound to the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(dependencyMgr);
    }

    protected void unsetDependencyManager(DependencyManagementService dependencyMgr) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Dependency management service unbound from the endpoint component");
        }
        ConfigHolder.getInstance().setDependencyManager(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        SynapseConfiguration synCfg = synapseEnvironment.getSynapseConfiguration();
        DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
        SynapseArtifactDeploymentStore deploymentStore = synCfg.getArtifactDeploymentStore();
        String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
        String messageStoreDirPath = synapseConfigPath + File.separator + "message-stores";
        for (MessageStore messageStore : synCfg.getMessageStores().values()) {
            if (messageStore.getFileName() == null) continue;
            deploymentStore.addRestoredArtifact(messageStoreDirPath + File.separator + messageStore.getFileName());
        }
        AxisConfiguration axisConfiguration = axisConfig;
        synchronized (axisConfiguration) {
            deploymentEngine.addDeployer((Deployer)new MessageStoreDeployer(), messageStoreDirPath, "xml");
        }
    }

    private void unregisterDeployer(AxisConfiguration axisConfig, SynapseEnvironment synapseEnvironment) {
        if (axisConfig != null) {
            DeploymentEngine deploymentEngine = (DeploymentEngine)axisConfig.getConfigurator();
            String synapseConfigPath = ServiceBusUtils.getSynapseConfigAbsPath((ServerContextInformation)synapseEnvironment.getServerContextInformation());
            String storeDirPath = synapseConfigPath + File.separator + "message-stores";
            deploymentEngine.removeDeployer(storeDirPath, "xml");
        }
    }

    public void createdConfigurationContext(ConfigurationContext configContext) {
        SynapseEnvironmentService synEnvService;
        AxisConfiguration axisConfig = configContext.getAxisConfiguration();
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (axisConfig != null && (synEnvService = ConfigHolder.getInstance().getSynapseEnvironmentService(tenantId)) != null) {
            try {
                this.registerDeployer(axisConfig, synEnvService.getSynapseEnvironment());
            }
            catch (Exception e) {
                log.error((Object)"Error while initializing MessageStore Admin", (Throwable)e);
            }
        }
    }
}

