/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.service;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.config.xml.MessageStoreFactory;
import org.apache.synapse.config.xml.MessageStoreSerializer;
import org.apache.synapse.message.store.MessageStore;
import org.wso2.carbon.mediation.initializer.AbstractServiceBusAdmin;
import org.wso2.carbon.mediation.initializer.ServiceBusUtils;
import org.wso2.carbon.mediation.initializer.persistence.MediationPersistenceManager;
import org.wso2.carbon.message.store.service.MessageInfo;
import org.wso2.carbon.message.store.service.MessageStoreMetaData;

public class MessageStoreAdminService
extends AbstractServiceBusAdmin {
    private static Log log = LogFactory.getLog(MessageStoreAdminService.class);
    public static final int MSGS_PER_PAGE = 10;
    public static final QName NAME_Q = new QName("", "name");
    public static final QName SEQUENCE_Q = new QName("", "sequence");
    public static final QName KEY_Q = new QName("", "key");
    public static final QName PARAMETER_Q = new QName("http://ws.apache.org/ns/synapse", "parameter");
    public static final String REGISTRY_KEY_PREFIX = "$registry:";
    public static final String EMPTY_STRING = "";
    protected static final OMFactory fac = OMAbstractFactory.getOMFactory();
    protected static final OMNamespace nullNS = fac.createOMNamespace("", "");

    public void addMessageStore(String xml) throws AxisFault {
        try {
            OMElement msElem = this.createElement(xml);
            SynapseConfiguration synapseConfiguration = this.getSynapseConfiguration();
            this.reformatKeyParameters(msElem, synapseConfiguration);
            MessageStore messageStore = MessageStoreFactory.createMessageStore((OMElement)msElem, (Properties)new Properties(), (SynapseConfiguration)synapseConfiguration);
            if (messageStore != null && messageStore.getName() != null) {
                String fileName = ServiceBusUtils.generateFileName((String)messageStore.getName());
                messageStore.setFileName(fileName);
                messageStore.init(this.getSynapseEnvironment());
                synapseConfiguration.addMessageStore(messageStore.getName(), messageStore);
                if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager mp = this.getMediationPersistenceManager();
                    mp.saveItem(messageStore.getName(), 10);
                }
            } else {
                String message = "Unable to create Message Store ";
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to create Message Store ";
            this.handleException(log, message, e);
        }
    }

    public void modifyMessageStore(String xml) throws AxisFault {
        try {
            MessageStore oldMessageStore;
            OMElement msElem = this.createElement(xml);
            SynapseConfiguration configuration = this.getSynapseConfiguration();
            this.reformatKeyParameters(msElem, configuration);
            MessageStore messageStore = MessageStoreFactory.createMessageStore((OMElement)msElem, (Properties)new Properties(), (SynapseConfiguration)configuration);
            if (messageStore == null) {
                String message = "Unable to edit the message Store. Error in the configuration";
                this.handleException(log, message, null);
            }
            if ((oldMessageStore = configuration.getMessageStore(messageStore.getName())) != null) {
                configuration.removeMessageStore(oldMessageStore.getName());
                oldMessageStore.destroy();
                String fileName = oldMessageStore.getFileName();
                messageStore.setFileName(fileName);
                messageStore.init(this.getSynapseEnvironment());
                configuration.addMessageStore(messageStore.getName(), messageStore);
                if (oldMessageStore.getArtifactContainerName() != null) {
                    messageStore.setArtifactContainerName(oldMessageStore.getArtifactContainerName());
                    messageStore.setIsEdited(true);
                } else if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                    MediationPersistenceManager mp = this.getMediationPersistenceManager();
                    mp.saveItem(messageStore.getName(), 10);
                }
            } else {
                assert (false);
                String message = "Unexpected Error!!! Message store with name " + messageStore.getName() + " does not exist";
                this.handleException(log, message, null);
            }
        }
        catch (XMLStreamException e) {
            String message = "Unable to Modify Message Store ";
            this.handleException(log, message, e);
        }
    }

    private OMElement reformatKeyParameters(OMElement elem, SynapseConfiguration config) throws AxisFault {
        Iterator params = elem.getChildrenWithName(PARAMETER_Q);
        HashMap parameters = new HashMap();
        while (params.hasNext()) {
            String msg;
            Object paramElement = params.next();
            if (!(paramElement instanceof OMElement)) continue;
            OMElement prop = (OMElement)paramElement;
            OMAttribute paramName = prop.getAttribute(NAME_Q);
            String paramValue = prop.getText();
            if (paramName != null && paramValue != null && paramValue.startsWith(REGISTRY_KEY_PREFIX)) {
                prop.addAttribute(fac.createOMAttribute(KEY_Q.getLocalPart(), nullNS, paramValue.replace(REGISTRY_KEY_PREFIX, EMPTY_STRING)));
                prop.setText(EMPTY_STRING);
                continue;
            }
            if (paramName == null) {
                msg = "Invalid MessageStore parameter - Parameter must have a name.";
                this.handleException(log, msg, null);
                continue;
            }
            if (paramValue != null) continue;
            msg = "Invalid MessageStore parameter - Parameter: " + paramName + " value cannot be null.";
            this.handleException(log, msg, null);
        }
        return elem;
    }

    public String getMessageStore(String name) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        MessageStore store = configuration.getMessageStore(name);
        if (store == null) {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
        return MessageStoreSerializer.serializeMessageStore(null, (MessageStore)store).toString();
    }

    public void deleteMessageStore(String name) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        if (configuration.getMessageStore(name) != null) {
            MessageStore removedMessageStore = configuration.getMessageStore(name);
            configuration.removeMessageStore(name);
            String fileName = removedMessageStore.getFileName();
            removedMessageStore.destroy();
            if (!Boolean.parseBoolean(System.getProperty("NonRegistryMode"))) {
                MediationPersistenceManager pm = this.getMediationPersistenceManager();
                pm.deleteItem(removedMessageStore.getName(), fileName, 10);
            }
        } else {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
    }

    public String[] getMessageStoreNames() throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        Set names = configuration.getMessageStores().keySet();
        return names.toArray(new String[names.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageStoreMetaData[] getMessageStoreData() throws AxisFault {
        Lock lock = this.getLock();
        try {
            lock.lock();
            SynapseConfiguration configuration = this.getSynapseConfiguration();
            assert (configuration != null);
            Set names = configuration.getMessageStores().keySet();
            ArrayList<MessageStoreMetaData> metaDatas = new ArrayList<MessageStoreMetaData>();
            for (String storeName : names) {
                MessageStoreMetaData data = new MessageStoreMetaData();
                MessageStore ms = this.getSynapseConfiguration().getMessageStore(storeName);
                data.setName(storeName);
                if (ms.getArtifactContainerName() != null) {
                    data.setArtifactContainerName(ms.getArtifactContainerName());
                }
                if (ms.isEdited()) {
                    data.setIsEdited(true);
                }
                metaDatas.add(data);
            }
            MessageStoreMetaData[] messageStoreMetaDataArray = metaDatas.toArray(new MessageStoreMetaData[metaDatas.size()]);
            return messageStoreMetaDataArray;
        }
        finally {
            lock.unlock();
        }
    }

    public int getSize(String name) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            return store.size();
        }
        this.handleException(log, "Message Store " + name + " does not exist !!!", null);
        return 0;
    }

    public String getClassName(String name) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            return store.getClass().getName();
        }
        this.handleException(log, "Message Store " + name + " does not exist !!!", null);
        return null;
    }

    public MessageInfo[] getAllMessages(String name) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            List messageContexts = store.getAll();
            ArrayList<MessageInfo> messageInfoList = new ArrayList<MessageInfo>();
            for (MessageContext mc : messageContexts) {
                MessageInfo info = MessageStoreAdminService.createMessageInfo(mc);
                if (info == null) continue;
                messageInfoList.add(info);
            }
        } else {
            this.handleException(log, "Message Store " + name + " does not exist !!!", null);
        }
        return null;
    }

    public MessageInfo[] getPaginatedMessages(String name, int pageNumber) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            int itemsPerPageInt = 10;
            int numberOfPages = (int)Math.ceil((double)store.size() / (double)itemsPerPageInt);
            if (numberOfPages == 0) {
                numberOfPages = 1;
            }
            if (pageNumber > numberOfPages - 1) {
                pageNumber = numberOfPages - 1;
            }
            int startIndex = pageNumber * itemsPerPageInt;
            int endIndex = (pageNumber + 1) * itemsPerPageInt;
            ArrayList<MessageInfo> paginatedMsgList = new ArrayList<MessageInfo>();
            for (int i = startIndex; i < endIndex && i < store.size(); ++i) {
                MessageInfo info = MessageStoreAdminService.createMessageInfo(store.get(i));
                if (info == null) continue;
                paginatedMsgList.add(info);
            }
            MessageInfo[] returnMsgs = paginatedMsgList.toArray(new MessageInfo[paginatedMsgList.size()]);
            return returnMsgs;
        }
        this.handleException(log, "Message Store " + name + " does not exist", null);
        return new MessageInfo[0];
    }

    public String getEnvelope(String name, String messageId) throws AxisFault {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        MessageStore store = configuration.getMessageStore(name);
        if (store != null) {
            MessageContext synCtx = store.get(messageId);
            if (synCtx != null) {
                return synCtx.getEnvelope().toString();
            }
            this.handleException(log, "Message with id " + messageId + " Does not exist", null);
        } else {
            this.handleException(log, "Message Store " + name + " does not exist !!!", null);
        }
        return null;
    }

    public void deleteAllMessages(String name) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            store.clear();
        } else {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
    }

    public void deleteMessage(String name, String messageId) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            MessageContext synCtx = store.remove(messageId);
            if (synCtx == null) {
                this.handleException(log, "Message with id " + messageId + " Does not exist", null);
            }
        } else {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
    }

    public void deleteFirstMessages(String name) throws AxisFault {
        MessageStore store = this.getMessageStoreImpl(name);
        if (store != null) {
            store.remove();
        } else {
            this.handleException(log, "Message Store " + name + " does not exist", null);
        }
    }

    private void handleException(Log log, String message, Exception e) throws AxisFault {
        if (e == null) {
            AxisFault exception = new AxisFault(message);
            log.error((Object)message, (Throwable)exception);
            throw exception;
        }
        message = message + " :: " + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw new AxisFault(message, (Throwable)e);
    }

    private static MessageInfo createMessageInfo(MessageContext messageContext) {
        if (messageContext == null) {
            return null;
        }
        MessageInfo messageInfo = new MessageInfo();
        messageInfo.setMessageId(messageContext.getMessageID());
        messageInfo.setSoapXml(messageContext.getEnvelope().toString());
        return messageInfo;
    }

    private MessageStore getMessageStoreImpl(String name) {
        SynapseConfiguration configuration = this.getSynapseConfiguration();
        assert (configuration != null);
        return configuration.getMessageStore(name);
    }

    private OMElement createElement(String str) throws XMLStreamException {
        byte[] bytes = null;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)("Unable to extract bytes in UTF-8 encoding. Extracting bytes in the system default encoding" + e.getMessage()));
            bytes = str.getBytes();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new StAXOMBuilder((InputStream)in).getDocumentElement();
    }
}

