/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.ui;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.message.store.stub.MessageInfo;
import org.wso2.carbon.message.store.stub.MessageStoreAdminServiceStub;
import org.wso2.carbon.message.store.stub.MessageStoreMetaData;
import org.wso2.carbon.message.store.ui.utils.MessageStoreData;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminDataSourceException;
import org.wso2.carbon.ndatasource.ui.stub.NDataSourceAdminStub;
import org.wso2.carbon.ndatasource.ui.stub.core.services.xsd.WSDataSourceInfo;

public class MessageStoreAdminServiceClient {
    private MessageStoreAdminServiceStub stub;
    private NDataSourceAdminStub nDataSourceAdminStub;
    private static final String adminServiceName = "MessageStoreAdminService";
    private static Log log = LogFactory.getLog(MessageStoreAdminServiceClient.class);
    public static int MESSAGE_STORES_PER_PAGE = 10;

    public MessageStoreAdminServiceClient(String cookie, String backendServerUrl, ConfigurationContext configurationContext) throws AxisFault {
        String serviceURL = backendServerUrl + adminServiceName;
        this.stub = new MessageStoreAdminServiceStub(configurationContext, serviceURL);
        ServiceClient client = this.stub._getServiceClient();
        Options option = client.getOptions();
        option.setManageSession(true);
        option.setProperty("Cookie", (Object)cookie);
        this.nDataSourceAdminStub = new NDataSourceAdminStub(configurationContext, "local://services/NDataSourceAdmin");
    }

    public void addMessageStore(String xml) throws Exception {
        try {
            if (xml != null) {
                this.stub.addMessageStore(xml);
            } else {
                this.handleException("Error Can't add message store. Error in the configuration " + xml);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void modifyMessageStore(String xml) throws Exception {
        try {
            if (xml != null) {
                this.stub.modifyMessageStore(xml);
            } else {
                this.handleException("Error Can't change message store. Error in the configuration " + xml);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteMessageStore(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteMessageStore(name);
            } else {
                this.handleException("Error Can't delete Message Store " + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String[] getMessageStoreNames() throws Exception {
        String[] messageStoreNames = null;
        try {
            messageStoreNames = this.stub.getMessageStoreNames();
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return messageStoreNames;
    }

    public MessageStoreData[] getMessageStoreData() throws Exception {
        ArrayList<MessageStoreData> messageStores = new ArrayList<MessageStoreData>();
        try {
            MessageStoreMetaData[] temp = this.stub.getMessageStoreData();
            if (temp == null || temp.length == 0 || temp[0] == null) {
                return null;
            }
            for (MessageStoreMetaData info : temp) {
                MessageStoreData storeData = new MessageStoreData();
                storeData.setName(info.getName());
                storeData.setArtifactContainerName(info.getArtifactContainerName());
                storeData.setIsEdited(info.getIsEdited());
                messageStores.add(storeData);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        if (messageStores.size() > 0) {
            return messageStores.toArray(new MessageStoreData[messageStores.size()]);
        }
        return null;
    }

    public MessageStoreData[] getPaginatedMessageStoreData(int pageNumber) throws Exception {
        int numberOfPages = 0;
        MessageStoreData[] messageStoreNames = this.getMessageStoreData();
        if (messageStoreNames != null) {
            numberOfPages = (int)Math.ceil((double)messageStoreNames.length / (double)MESSAGE_STORES_PER_PAGE);
        }
        if (pageNumber == 0) {
            numberOfPages = 1;
        }
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * MESSAGE_STORES_PER_PAGE;
        int endIndex = (pageNumber + 1) * MESSAGE_STORES_PER_PAGE;
        if (messageStoreNames == null) {
            return null;
        }
        ArrayList<MessageStoreData> nameList = new ArrayList<MessageStoreData>();
        for (int i = startIndex; i < endIndex && i < messageStoreNames.length; ++i) {
            nameList.add(messageStoreNames[i]);
        }
        return nameList.toArray(new MessageStoreData[nameList.size()]);
    }

    public String[] getPaginatedMessageStoreNames(int pageNumber) throws Exception {
        int numberOfPages = 0;
        String[] messageStoreNames = this.getMessageStoreNames();
        if (messageStoreNames != null) {
            numberOfPages = (int)Math.ceil((double)messageStoreNames.length / (double)MESSAGE_STORES_PER_PAGE);
        }
        if (pageNumber == 0) {
            numberOfPages = 1;
        }
        if (pageNumber > numberOfPages - 1) {
            pageNumber = numberOfPages - 1;
        }
        int startIndex = pageNumber * MESSAGE_STORES_PER_PAGE;
        int endIndex = (pageNumber + 1) * MESSAGE_STORES_PER_PAGE;
        if (messageStoreNames == null) {
            return null;
        }
        ArrayList<String> nameList = new ArrayList<String>();
        for (int i = startIndex; i < endIndex && i < messageStoreNames.length; ++i) {
            nameList.add(messageStoreNames[i]);
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    public MessageInfo[] getPaginatedMessages(String name, int pageNumber) throws Exception {
        MessageInfo[] messageInfos = null;
        try {
            if (name != null) {
                messageInfos = this.stub.getPaginatedMessages(name, pageNumber);
            } else {
                this.handleException("Error Can't get messages form Message Store " + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return messageInfos;
    }

    public int getSize(String name) throws Exception {
        int size = 0;
        try {
            if (name != null) {
                size = this.stub.getSize(name);
            } else {
                this.handleException("Error Can't get Message Store size for Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return size;
    }

    public String getEnvelope(String name, String messageId) throws Exception {
        String envelope = null;
        try {
            if (name != null) {
                envelope = this.stub.getEnvelope(name, messageId);
            } else {
                this.handleException("Error Can't access Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return envelope;
    }

    public MessageStoreData getMessageStore(String name) throws Exception {
        MessageStoreData data = null;
        try {
            if (name != null) {
                String xml = this.stub.getMessageStore(name);
                assert (xml != null);
                data = new MessageStoreData(xml);
            } else {
                this.handleException("Error Can't access Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return data;
    }

    public void deleteAllMessages(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteAllMessages(name);
            } else {
                this.handleException("Error Can't delete all messages from Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteMessage(String name, String messageId) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteMessage(name, messageId);
            } else {
                this.handleException("Error accessing Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void deleteFirstMessages(String name) throws Exception {
        try {
            if (name != null) {
                this.stub.deleteFirstMessages(name);
            } else {
                this.handleException("Error accessing Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public String getClassName(String name) throws Exception {
        String className = null;
        try {
            if (name != null) {
                className = this.stub.getClassName(name);
            } else {
                this.handleException("Error accessing Message store" + name);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        return className;
    }

    public List<String> getAllDataSourceInformations() throws RemoteException, NDataSourceAdminDataSourceException {
        WSDataSourceInfo[] wsDataSourceInfo = this.nDataSourceAdminStub.getAllDataSources();
        ArrayList<String> sourceList = new ArrayList<String>();
        if (wsDataSourceInfo == null || wsDataSourceInfo.length == 0) {
            return sourceList;
        }
        for (WSDataSourceInfo info : wsDataSourceInfo) {
            if (info.getDsMetaInfo().getJndiConfig() == null) continue;
            sourceList.add(info.getDsMetaInfo().getJndiConfig().getName());
        }
        return sourceList;
    }

    public boolean isMBbased(String name) throws Exception {
        MessageStoreData data;
        Map<String, String> paramsMap;
        return "org.apache.synapse.message.store.impl.jms.JmsStore".equals(this.getClassName(name)) && (paramsMap = (data = this.getMessageStore(name)).getParams()).containsKey("connectionfactory.QueueConnectionFactory");
    }

    private void handleException(Exception e) throws Exception {
        String message = "Error Executing MessageStoreAdminServiceClient" + e.getMessage();
        log.error((Object)message, (Throwable)e);
        throw e;
    }

    private void handleException(String message) throws Exception {
        log.error((Object)message);
        throw new Exception(message);
    }
}

