/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.message.store.ui.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.synapse.config.xml.MessageStoreFactory;
import org.apache.synapse.util.xpath.SynapseJsonPath;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;
import org.wso2.carbon.message.store.ui.utils.PathInfo;

public class MessageStoreData {
    private String name;
    private String clazz;
    private String sequence;
    private Map<String, String> params = new HashMap<String, String>();
    private PathInfo pathInfo;
    private String artifactContainerName;
    private boolean isEdited;
    public static final String REGISTRY_KEY_PREFIX = "$registry:";

    public MessageStoreData() {
    }

    public MessageStoreData(String xml) throws XMLStreamException, JaxenException {
        this.populate(xml);
    }

    public String getName() {
        return this.name;
    }

    public String getSequence() {
        return this.sequence;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public PathInfo getPathInfo() {
        return this.pathInfo;
    }

    public String getClazz() {
        return this.clazz;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setClazz(String provider) {
        this.clazz = provider;
    }

    private SynapseXPath getXPathExpression(OMElement element, String expression) throws JaxenException {
        return new SynapseXPath(element, expression);
    }

    private void populate(String xml) throws XMLStreamException, JaxenException {
        ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());
        OMElement elem = new StAXOMBuilder((InputStream)in).getDocumentElement();
        OMAttribute attElem = elem.getAttribute(MessageStoreFactory.CLASS_Q);
        if (attElem != null) {
            this.clazz = attElem.getAttributeValue();
        }
        if ((attElem = elem.getAttribute(MessageStoreFactory.NAME_Q)) != null) {
            this.name = attElem.getAttributeValue();
        }
        if ((attElem = elem.getAttribute(MessageStoreFactory.SEQUENCE_Q)) != null) {
            this.sequence = attElem.getAttributeValue();
        }
        Iterator it = elem.getChildrenWithName(MessageStoreFactory.PARAMETER_Q);
        while (it.hasNext()) {
            String value;
            OMElement paramElem = (OMElement)it.next();
            OMAttribute nameAtt = paramElem.getAttribute(MessageStoreFactory.NAME_Q);
            OMAttribute expressionAttribute = paramElem.getAttribute(MessageStoreFactory.EXPRESSION_Q);
            OMAttribute keyAtt = paramElem.getAttribute(MessageStoreFactory.KEY_Q);
            assert (nameAtt != null);
            String name = nameAtt.getAttributeValue();
            if (expressionAttribute != null) {
                value = expressionAttribute.getAttributeValue();
                this.pathInfo = new PathInfo();
                if (!value.startsWith("json")) {
                    SynapseXPath xPathExpression = this.getXPathExpression(paramElem, value);
                    this.pathInfo.setxPath(xPathExpression);
                } else {
                    SynapseJsonPath jsonPath = new SynapseJsonPath(value);
                    this.pathInfo.setJsonPath(jsonPath);
                }
            } else {
                value = keyAtt != null ? REGISTRY_KEY_PREFIX + keyAtt.getAttributeValue() : paramElem.getText();
            }
            this.params.put(name, value);
        }
    }

    public String getString() {
        StringBuffer storeString = new StringBuffer();
        storeString.append("name: " + this.name + "\n");
        storeString.append("clazz: " + this.clazz + "\n");
        storeString.append("sequence: " + this.sequence + "\n");
        storeString.append("params: " + this.params + "\n");
        return storeString.toString();
    }

    public String getArtifactContainerName() {
        return this.artifactContainerName;
    }

    public void setArtifactContainerName(String artifactContainerName) {
        this.artifactContainerName = artifactContainerName;
    }

    public boolean getIsEdited() {
        return this.isEdited;
    }

    public void setIsEdited(boolean isEdited) {
        this.isEdited = isEdited;
    }
}

