/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.relay.mediators.builder.xml;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.builder.Builder;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.synapse.Mediator;
import org.apache.synapse.config.xml.AbstractMediatorFactory;
import org.wso2.carbon.relay.MessageBuilder;
import org.wso2.carbon.relay.mediators.builder.BuilderMediator;

public class BuilderMediatorFactory
extends AbstractMediatorFactory {
    private QName BUILDER_T = new QName("http://ws.apache.org/ns/synapse", "builder");
    private QName MESSAGE_BUILDER_T = new QName("http://ws.apache.org/ns/synapse", "messageBuilder");
    private QName CONTENT_TYPE_ATT = new QName("contentType");
    private QName BUILDER_CLASS_ATT = new QName("class");
    private QName FORMATTER_CLASS_ATT = new QName("formatterClass");

    public QName getTagQName() {
        return this.BUILDER_T;
    }

    protected Mediator createSpecificMediator(OMElement omElement, Properties properties) {
        BuilderMediator builderMediator = new BuilderMediator();
        OMAttribute builderClassAtt = omElement.getAttribute(this.BUILDER_CLASS_ATT);
        if (builderClassAtt != null) {
            OMAttribute formatterClassAtt = omElement.getAttribute(this.FORMATTER_CLASS_ATT);
            if (formatterClassAtt == null) {
                this.handleException("formatterClass attribute is required");
                return null;
            }
            try {
                Builder specifiedBuilder = MessageBuilder.createBuilder((String)builderClassAtt.getAttributeValue());
                MessageFormatter specifiedFormatter = MessageBuilder.createFormatter((String)formatterClassAtt.getAttributeValue());
                builderMediator.setSpecifiedBuilder(specifiedBuilder);
                builderMediator.setSpecifiedFormatter(specifiedFormatter);
            }
            catch (AxisFault axisFault) {
                this.handleException("Invalid builder/formatter class.", (Exception)((Object)axisFault));
                return null;
            }
        }
        Iterator it = omElement.getChildrenWithName(this.MESSAGE_BUILDER_T);
        while (it.hasNext()) {
            OMAttribute formatterClassAtt;
            OMElement e = (OMElement)it.next();
            OMAttribute contentTypeAtt = e.getAttribute(this.CONTENT_TYPE_ATT);
            if (contentTypeAtt == null) {
                this.handleException("contentType attribute is required");
                return null;
            }
            OMAttribute builderClasAtt = e.getAttribute(this.BUILDER_CLASS_ATT);
            if (builderClasAtt == null) {
                this.handleException("class attribute is required");
                return null;
            }
            try {
                builderMediator.addBuilder(contentTypeAtt.getAttributeValue(), MessageBuilder.createBuilder((String)builderClasAtt.getAttributeValue()));
            }
            catch (AxisFault axisFault) {
                this.handleException("Error creating message builder: " + builderClasAtt.getAttributeValue(), (Exception)((Object)axisFault));
            }
            if ((formatterClassAtt = e.getAttribute(this.FORMATTER_CLASS_ATT)) == null || formatterClassAtt.getAttributeValue() == null) continue;
            try {
                builderMediator.addFormatter(contentTypeAtt.getAttributeValue(), MessageBuilder.createFormatter((String)formatterClassAtt.getAttributeValue()));
            }
            catch (AxisFault axisFault) {
                this.handleException("Error creating message formatter: " + formatterClassAtt.getAttributeValue(), (Exception)((Object)axisFault));
            }
        }
        BuilderMediatorFactory.addAllCommentChildrenToList((OMElement)omElement, (List)builderMediator.getCommentsList());
        return builderMediator;
    }
}

