/**
 *  Copyright (c) 2009, WSO2 Inc. (http://www.wso2.org) All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package org.wso2.carbon.rest.api;


public class APIData {
	
	private String name;
	
	private String host;
	
	private int port = -1;
	
	private String context;
	
	private String fileName;

	private String artifactContainerName;

	private boolean isEdited;
	
	private ResourceData[] resources;

	private boolean isStatisticsEnable;

	private boolean isTracingEnable;

	// API version that is defined as an attribute in api tag
	private String version;

	// version type describes the way "version" will be used
	private String versionType;

	private String swaggerDefKey;

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}
	
	public String getHost() {
		return host;
	}

	public void setHost(String host) {
		this.host = host;
	}

	public int getPort() {
		return port;
	}

	public void setPort(int port) {
		this.port = port;
	}

	public String getContext() {
		return context;
	}

	public void setContext(String context) {
		this.context = context;
	}

	public ResourceData[] getResources() {
		return resources;
	}

	public void setResources(ResourceData[] resources) {
		this.resources = resources;
	}
	
	public String getFileName() {
		return fileName;
	}

	public void setFileName(String fileName) {
		this.fileName = fileName;
	}

	/**
	 * Get the artifactContainer of the endpoint which deployed from
	 * @return endpoint description
	 */
	public String getArtifactContainerName() {
		return artifactContainerName;
	}

	/**
	 * Set the endpoint artifact container name as a metadata
	 * @param artifactContainerName endpoint name
	 */
	public void setArtifactContainerName(String artifactContainerName) {
		this.artifactContainerName = artifactContainerName;
	}

	/**
	 * Get the edit state of the endpoint
	 * @return endpoint description
	 */
	public boolean getIsEdited() {
		return isEdited;
	}

	/**
	 * Set the edit state of the endpoint as a metadata
	 * @param isEdited endpoint name
	 */
	public void setIsEdited(boolean isEdited) {
		this.isEdited = isEdited;
	}

	public void setStatisticsEnable(boolean enableStatistics) {
		this.isStatisticsEnable = enableStatistics;
	}

	public boolean getStatisticsEnable() {
		return isStatisticsEnable;
	}

	public boolean getTracingEnable() {
		return isTracingEnable;
	}

	public void setTracingEnable(boolean tracingEnable) {
		isTracingEnable = tracingEnable;
	}

	/**
	 *
	 * @returns API version
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * Set the given version as the API version
	 * @param version
	 */
	public void setVersion(String version) {
		this.version = version;
	}

	/**
	 *
	 * @returns the version type of the API
	 */
	public String getVersionType() {
		return versionType;
	}

	/**
	 * Set the given version type for the API
	 * @param versionType
	 */
	public void setVersionType(String versionType) {
		this.versionType = versionType;
	}

	/**
	 * Function to set Swagger definition path
	 * @return
	 */
	public String getSwaggerDefKey() {
		return swaggerDefKey;
	}

	/**
	 * Function to set Swagger definition path
	 * @param swaggerDefKey
	 */
	public void setSwaggerDefKey(String swaggerDefKey) {
		this.swaggerDefKey = swaggerDefKey;
	}
}
